/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGoToSymbolContributor
implements GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        List names = this.getRoots(project, includeNonProjectItems).map(o -> ((DbDataSourceImpl)((Object)o)).getAllNames()).toList();
        int count2 = 0;
        for (Collection o2 : names) {
            count2 += o2.size();
        }
        String[] result2 = new String[count2];
        count2 = 0;
        for (Collection o3 : names) {
            for (String s : o3) {
                result2[count2++] = s;
            }
        }
        if (result2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        return result2;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (DbDataSource dataSource : this.getRoots(project, includeNonProjectItems)) {
            this.filterObjects(((DbDataSourceImpl)dataSource).getObjectsByName(name)).filterMap(o -> DbImplUtil.findElement(dataSource, o)).addAllTo((Collection)result2);
        }
        NavigationItem[] navigationItemArray = result2.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    @NotNull
    public JBIterable<DasObject> filterObjects(@NotNull Collection<DasObject> objects) {
        if (objects == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = JBIterable.from(objects);
        if (jBIterable == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (!(item instanceof DbElement)) {
            return null;
        }
        DbDataSource dataSource = ((DbElement)item).getDataSource();
        String groupName = ((AbstractDataSource)dataSource.getDelegate()).getGroupName();
        return (groupName == null ? "" : groupName + "/") + dataSource.getName() + "/" + QNameUtil.getQualifiedName((DbElement)item);
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "/";
    }

    protected JBIterable<DbDataSource> getRoots(Project project, boolean includeNonProjectItems) {
        JBIterable result2 = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources());
        return includeNonProjectItems ? result2 : result2.filter(o -> {
            DatabaseSystem delegate = o.getDelegate();
            return !(delegate instanceof LocalDataSource) || !((LocalDataSource)delegate).isGlobal();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterObjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

