/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRowAction
extends DumbAwareAction
implements GridAction {
    public AddRowAction() {
        super(null, null, AllIcons.General.Add);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        DataGrid dataGrid;
        if (e == null) {
            AddRowAction.$$$reportNull$$$0(0);
        }
        boolean visible = (dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) != null && dataGrid.isEditable();
        boolean bl = enabled = visible && AddRowAction.canAddRow(dataGrid);
        if (enabled && dataGrid.isEditing()) {
            enabled = !(e.getInputEvent() instanceof KeyEvent);
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            AddRowAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) != null) {
            dataGrid.insertRow();
            DataGridUtil.focusDataGrid(dataGrid);
        }
    }

    public static boolean canAddRow(@Nullable DataGrid dataGrid) {
        boolean canAddRow = dataGrid != null && dataGrid.isEditable() && dataGrid.isReady() && dataGrid.getDataSupport().hasRowMutator() && dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() != 0;
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        if (canAddRow && table != null) {
            return DasUtil.getColumns((DasObject)table).filter(columnInfo -> !DataGridUtil.findColumn(dataGrid, columnInfo.getName()).isValid(dataGrid) && !DasUtil.isAuto((DasColumn)columnInfo) && columnInfo.getDefault() == null && columnInfo.isNotNull()).isEmpty();
        }
        return canAddRow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/run/actions/AddRowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

