/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class GridScrollPosition {
    private final int myTopRowIdx;
    private final int myLeftColumnIdx;

    private GridScrollPosition(int topRowIdx, int leftColumnIdx) {
        this.myTopRowIdx = topRowIdx;
        this.myLeftColumnIdx = leftColumnIdx;
    }

    public static GridScrollPosition store(@NotNull JTable table) {
        if (table == null) {
            GridScrollPosition.$$$reportNull$$$0(0);
        }
        Rectangle visibleRect = table.getVisibleRect();
        Point p2 = visibleRect.getLocation();
        ++p2.x;
        ++p2.y;
        return new GridScrollPosition(table.rowAtPoint(p2), table.columnAtPoint(p2));
    }

    public void restore(@NotNull JTable table) {
        if (table == null) {
            GridScrollPosition.$$$reportNull$$$0(1);
        }
        Rectangle targetRect = table.getCellRect(this.myTopRowIdx, this.myLeftColumnIdx, true);
        Rectangle visibleRect = table.getVisibleRect();
        targetRect.width = visibleRect.width;
        targetRect.height = visibleRect.height;
        table.scrollRectToVisible(targetRect);
    }

    public GridScrollPosition transpose() {
        return new GridScrollPosition(this.myLeftColumnIdx, this.myTopRowIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "table";
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridScrollPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

