/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.selection;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.ui.JBAutoscroller;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class GridSelectionModel
implements SelectionModel<DataConsumer.Row, DataConsumer.Column> {
    private final TableResultView myTable;
    private final DataGrid myGrid;
    private final JBAutoscroller.AutoscrollLocker myLocker;
    private final HiddenColumnsSelectionHolder myHolder;
    private final GridSelectionTracker myTracker;

    public GridSelectionModel(@NotNull TableResultView table, @NotNull DataGrid grid, @NotNull JBAutoscroller.AutoscrollLocker locker, @NotNull HiddenColumnsSelectionHolder holder) {
        if (table == null) {
            GridSelectionModel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridSelectionModel.$$$reportNull$$$0(1);
        }
        if (locker == null) {
            GridSelectionModel.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            GridSelectionModel.$$$reportNull$$$0(3);
        }
        this.myTable = table;
        this.myGrid = grid;
        this.myLocker = locker;
        this.myHolder = holder;
        this.myTracker = new GridSelectionTracker(grid, table);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            GridSelectionModel.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            GridSelectionModel.$$$reportNull$$$0(5);
        }
        ViewIndex<DataConsumer.Row> viewRow = row.toView(this.myGrid);
        ViewIndex<DataConsumer.Column> viewColumn = column2.toView(this.myGrid);
        int displayRow = this.myGrid.isTransposed() ? viewColumn.asInteger() : viewRow.asInteger();
        int displayColumn = this.myGrid.isTransposed() ? viewRow.asInteger() : viewColumn.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    @Override
    public boolean isSelectedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            GridSelectionModel.$$$reportNull$$$0(6);
        }
        ViewIndex<DataConsumer.Column> colIdx = column2.toView(this.myGrid);
        int index2 = colIdx.asInteger();
        return this.myGrid.isTransposed() ? this.myTable.isRowSelected(index2) : this.myTable.isColumnSelected(index2);
    }

    @Override
    public boolean isSelectedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            GridSelectionModel.$$$reportNull$$$0(7);
        }
        ViewIndex<DataConsumer.Row> rowIdx = row.toView(this.myGrid);
        int index2 = rowIdx.asInteger();
        return this.myGrid.isTransposed() ? this.myTable.isColumnSelected(index2) : this.myTable.isRowSelected(index2);
    }

    @Override
    public void clearSelection() {
        this.myTable.clearSelection();
    }

    @Override
    public int getSelectedRowCount() {
        return this.myGrid.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.myGrid.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        int viewRowIndex = this.myGrid.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this.myGrid, viewRowIndex >= 0 ? viewRowIndex : -1).toModel(this.myGrid);
        if (modelIndex == null) {
            GridSelectionModel.$$$reportNull$$$0(8);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ViewIndexSet.forRows(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            GridSelectionModel.$$$reportNull$$$0(9);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn()).toModel(this.myGrid);
        if (modelIndex == null) {
            GridSelectionModel.$$$reportNull$$$0(10);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ViewIndexSet.forColumns(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            GridSelectionModel.$$$reportNull$$$0(11);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTracker gridSelectionTracker = this.myTracker;
        if (gridSelectionTracker == null) {
            GridSelectionModel.$$$reportNull$$$0(12);
        }
        return gridSelectionTracker;
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            GridSelectionModel.$$$reportNull$$$0(13);
        }
        this.doSetSelection(true, columns.toView(this.myGrid).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridSelectionModel.$$$reportNull$$$0(14);
        }
        this.doSetSelection(false, rows.toView(this.myGrid).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> rows) {
        if (rows == null) {
            GridSelectionModel.$$$reportNull$$$0(15);
        }
        this.doSetSelection(false, rows.toView(this.myGrid).asInteger());
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> columns) {
        if (columns == null) {
            GridSelectionModel.$$$reportNull$$$0(16);
        }
        this.doSetSelection(true, columns.toView(this.myGrid).asInteger());
    }

    @Override
    public void selectWholeRow() {
        this.myLocker.runWithLock(() -> {
            this.myHolder.setWholeRowSelected(!this.myGrid.isTransposed());
            GridSelection.setColumnSelectionInterval((JTable)((Object)this.myTable), this.myTable.getColumnCount() - 1, 0);
        });
    }

    @Override
    public void selectWholeColumn() {
        this.myLocker.runWithLock(() -> GridSelection.setRowSelectionInterval((JTable)((Object)this.myTable), this.myTable.getRowCount() - 1, 0));
    }

    private void doSetSelection(boolean isColumnSelection, int ... selection) {
        boolean transposed = this.myGrid.isTransposed();
        if (isColumnSelection && !transposed || !isColumnSelection && transposed) {
            GridSelection.setColumnSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedRow() == -1) {
                GridSelection.setRowSelection((JTable)((Object)this.myTable), 0);
            }
        } else {
            GridSelection.setRowSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedColumn() == -1) {
                GridSelection.setColumnSelection((JTable)((Object)this.myTable), 0);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/selection/GridSelectionModel";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/selection/GridSelectionModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedRow";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

