/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.util.containers.ContainerUtil;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaExporters {
    private final SortedSet<Exporter<? extends DeObject, ? extends DasObject>> myExporters = ContainerUtil.newTreeSet((o1, o2) -> {
        boolean de2;
        Class e2;
        Class e1 = o1.getExportableClass();
        if (e1 == (e2 = o2.getExportableClass())) {
            return o1.compareTo(o2);
        }
        boolean de1 = e1.isAssignableFrom(DeObject.class);
        if (de1 != (de2 = e2.isAssignableFrom(DeObject.class))) {
            return de1 ? -1 : 1;
        }
        return e1.isAssignableFrom(e2) ? 1 : -1;
    });

    public void add(Exporter<? extends DeObject, ? extends DasObject> exporter) {
        this.myExporters.add(exporter);
    }

    @Nullable
    public Exporter<? extends DeObject, DasObject> get(@Nullable DasObject object) {
        if (object == null) {
            return null;
        }
        for (Exporter exporter : this.myExporters) {
            Exporter tmp;
            if (!exporter.getExportableClass().isAssignableFrom(object.getClass()) || !(tmp = exporter).canExport(object)) continue;
            return tmp;
        }
        return null;
    }

    @Nullable
    public Exporter<? extends DeObject, DasObject> getApplier(@Nullable DeObject object) {
        if (object == null) {
            return null;
        }
        Exporter found = null;
        for (Exporter exporter : this.myExporters) {
            if (!exporter.getExportedClass().isAssignableFrom(object.getClass()) || found != null && !found.getExportedClass().isAssignableFrom(exporter.getExportedClass())) continue;
            found = exporter;
        }
        return found;
    }

    protected static interface Exporter<De extends DeObject, Das extends DasObject>
    extends Comparable<Exporter<? extends DeObject, ? extends DasObject>> {
        @NotNull
        public Class<De> getExportedClass();

        @NotNull
        public Class<Das> getExportableClass();

        public boolean canExport(@NotNull Das var1);

        @NotNull
        public De create(@NotNull SchemaExportHelper var1, @NotNull Das var2);

        public void apply(SchemaApplyHelper var1, @NotNull De var2, @NotNull Das var3);

        public void applyChildren(SchemaApplyHelper var1, @NotNull De var2, @NotNull Das var3);

        public void lightExport(@NotNull SchemaExportHelper var1, @NotNull De var2, @NotNull Das var3);

        public void exportChildren(@NotNull SchemaExportHelper var1, @NotNull De var2, @NotNull Das var3);
    }
}

