/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Dbms myDbms;
    @NotNull
    private final DatabaseDialectEx myDialect;
    @Nullable
    private final BasicModel myModel;
    @Nullable
    private final DbDataSource myDataSource;
    @Nullable
    private final SearchPath mySearchPath;
    @Nullable
    private final VirtualFile myVirtualFile;
    @Nullable
    private final Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> myMapping;

    public DatabaseEditorContext(@NotNull DbElement element2, @Nullable VirtualFile virtualFile) {
        if (element2 == null) {
            DatabaseEditorContext.$$$reportNull$$$0(0);
        }
        this(element2.getDataSource().getProject(), element2.getDataSource().getDbms(), (BasicModel)ObjectUtils.tryCast((Object)element2.getDataSource().getModel(), BasicModel.class), element2.getDataSource(), ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObjectForSwitch(element2)), virtualFile, null);
    }

    private DatabaseEditorContext(@NotNull SqlFile file) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(1);
        }
        this(file, DbImplUtil.getForcedDataSource((PsiFile)file), null, null);
    }

    private DatabaseEditorContext(@NotNull SqlFile file, @Nullable DbDataSource dataSource, @Nullable BasicModel model, @Nullable Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> mapping) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(2);
        }
        this(file.getProject(), file.getSqlLanguage().getDbms(), model, dataSource, DatabaseEditorHelper.getSearchPath((PsiFile)file), DatabaseEditorContext.getWritableFile(file), mapping);
    }

    @Nullable
    private static VirtualFile getWritableFile(@NotNull SqlFile file) {
        VirtualFile vfile;
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(3);
        }
        return (vfile = file.getViewProvider().getVirtualFile()).isWritable() ? vfile : null;
    }

    @NotNull
    public static DatabaseEditorContext forFile(@NotNull SqlFile file, boolean light) {
        DbDataSource forced;
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(4);
        }
        JBIterable<DbDataSource> dataSources2 = (forced = DbImplUtil.getForcedDataSource((PsiFile)file)) == null ? DbSqlUtil.getAppropriateDataSources((PsiFile)file, false, true) : JBIterable.of((Object)forced);
        for (DbDataSource dataSource : dataSources2) {
            SqlDataSource sqlSource = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
            if (sqlSource == null || !sqlSource.containsFile(PsiUtilCore.getVirtualFile((PsiElement)file))) continue;
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext((DbElement)dataSource, file.getVirtualFile());
            if (databaseEditorContext == null) {
                DatabaseEditorContext.$$$reportNull$$$0(5);
            }
            return databaseEditorContext;
        }
        if (light) {
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file);
            if (databaseEditorContext == null) {
                DatabaseEditorContext.$$$reportNull$$$0(6);
            }
            return databaseEditorContext;
        }
        BasicModModel model = new ModelFactory(new MemoryTextStorage()).createModel(file.getSqlLanguage().getDbms());
        Map mapping = SqlPsiFacade.getInstance((Project)file.getProject()).buildModel((DasModel)model, Collections.singletonList(file), null);
        DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file, (DbDataSource)dataSources2.first(), model, mapping);
        if (databaseEditorContext == null) {
            DatabaseEditorContext.$$$reportNull$$$0(7);
        }
        return databaseEditorContext;
    }

    public DatabaseEditorContext(@NotNull Project project, @NotNull Dbms dbms, @Nullable BasicModel model, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable VirtualFile virtualFile, @Nullable Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            DatabaseEditorContext.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DatabaseEditorContext.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        this.myDbms = model == null ? dbms : model.getDbms();
        this.myModel = model;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myVirtualFile = virtualFile;
        this.myMapping = mapping;
        this.myDialect = DbImplUtil.getDatabaseDialect(this.myDbms);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DatabaseEditorContext.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            DatabaseEditorContext.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @NotNull
    public final DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DatabaseEditorContext.$$$reportNull$$$0(12);
        }
        return databaseDialectEx;
    }

    @Nullable
    public Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> getMapping() {
        return this.myMapping;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect;
        if (this.myDataSource != null) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)this.myDataSource);
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(13);
            }
            return sqlLanguageDialect;
        }
        if (this.myVirtualFile != null && (dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)this.myVirtualFile), SqlLanguageDialect.class)) != null) {
            SqlLanguageDialect sqlLanguageDialect = dialect;
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(14);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(this.myDbms);
        if (sqlLanguageDialect == null) {
            DatabaseEditorContext.$$$reportNull$$$0(15);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public BasicModel getModel() {
        return this.myModel;
    }

    @NotNull
    public CasingProvider getCasingProvider() {
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.chooseNotNull((Object)this.getModel(), (Object)DbImplUtil.getDatabaseDialect(this.myDbms));
        if (casingProvider == null) {
            DatabaseEditorContext.$$$reportNull$$$0(16);
        }
        return casingProvider;
    }

    @Nullable
    public DbDataSource getDataSource() {
        return this.myDataSource;
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Nullable
    public VirtualFile getOrCreateVirtualFile() {
        if (this.myVirtualFile != null) {
            return this.myVirtualFile;
        }
        if (this.myDataSource != null) {
            return DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)this.myDataSource);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWritableFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

