/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlBinaryExpressionCompletionProvider;
import com.intellij.sql.completion.providers.SqlColumnListCompletionProvider;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.completion.providers.SqlParameterNamesCompletionProvider;
import com.intellij.sql.completion.providers.SqlReferenceExpressionCompletionProvider;
import com.intellij.sql.completion.providers.SqlValuesCompletionProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionContributor
extends CompletionContributor {
    private static final Collection<CompletionProvider<CompletionParameters>> BASIC_PROVIDERS = ContainerUtil.list((Object[])new CompletionProvider[]{new SqlColumnListCompletionProvider(), new SqlValuesCompletionProvider(), new SqlParameterNamesCompletionProvider(), new SqlBinaryExpressionCompletionProvider(), new SqlReferenceExpressionCompletionProvider()});
    private static final Collection<CompletionProvider<CompletionParameters>> SMART_PROVIDERS = ContainerUtil.list((Object[])new CompletionProvider[]{new SqlJoinSmartCompletionProvider()});

    public SqlCompletionContributor() {
        for (CompletionProvider<CompletionParameters> provider : BASIC_PROVIDERS) {
            this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), provider);
        }
        for (CompletionProvider<CompletionParameters> provider : SMART_PROVIDERS) {
            this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), provider);
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        String prevElementText;
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element2 = file.findElementAt(offset);
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDatabaseDialect();
        PsiElement prevElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        IElementType prevLeafType = prevElement instanceof LeafPsiElement ? ((LeafPsiElement)prevElement).getElementType() : null;
        PsiElement psiElement = prevElement = prevElement instanceof PsiWhiteSpace || prevLeafType == SqlTokens.SQL_IDENT ? PsiTreeUtil.prevLeaf((PsiElement)prevElement) : prevElement;
        if (prevLeafType == SqlTokens.SQL_UNCLOSED_TOKEN || prevElement != null && (prevElementText = prevElement.getText()) != null && String.valueOf(dialect.openQuote()).equals(prevElementText)) {
            char currentQuote = prevElement == null ? dialect.openQuote() : prevElement.getText().charAt(0);
            char closingQuote = currentQuote == dialect.openQuote() ? dialect.closeQuote() : currentQuote;
            context.setDummyIdentifier(String.valueOf(closingQuote));
        } else if (element2 != null) {
            ASTNode node = element2.getNode();
            IElementType type = node != null ? node.getElementType() : null;
            boolean doNotPatch = type instanceof SqlKeywordTokenType && ((SqlFile)file).getSqlLanguage().isReservedKeyword(type);
            doNotPatch = doNotPatch || (element2.getTextRange().getStartOffset() != offset || element2.getParent() instanceof SqlIdentifier) && file.findReferenceAt(offset) != null;
            SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlPrefixedElement.class, (boolean)false);
            if (doNotPatch || prefixed != null && prefixed.getNamePrefix() != null) {
                context.setDummyIdentifier("");
            }
            SqlCompletionContributor.tuneReplacementOffset(context, element2);
        }
    }

    private static void tuneReplacementOffset(@NotNull CompletionInitializationContext context, @NotNull PsiElement element2) {
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(2);
        }
        ASTNode node = element2.getNode();
        int offset = context.getStartOffset();
        IElementType type = node != null ? node.getElementType() : null;
        TextRange elementRange = element2.getTextRange();
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset == elementRange.getStartOffset()) {
            context.setReplacementOffset(elementRange.getEndOffset());
        }
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset != elementRange.getStartOffset()) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, elementRange.getEndOffset() - 1);
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, elementRange.getEndOffset() - 1);
        }
    }

    public static SqlTableType retrieveTableTypeForVariable(@Nullable PsiElement e) {
        if (!(e instanceof SqlReferenceExpression)) {
            return null;
        }
        ObjectKind kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind();
        if (kind == ObjectKind.VARIABLE) {
            for (ResolveResult result2 : ((SqlReferenceExpression)e).multiResolve(true)) {
                SqlType type;
                if (!result2.isValidResult() || !(result2.getElement() instanceof SqlVariableDefinition) || !((type = ((SqlVariableDefinition)result2.getElement()).getSqlType()) instanceof SqlTableType)) continue;
                return (SqlTableType)type;
            }
        }
        return null;
    }

    @Nullable
    public static DasTable retrieveTable(@Nullable PsiElement e) {
        if (!(e instanceof SqlReferenceExpression)) {
            return null;
        }
        ObjectKind kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind();
        if (kind != ObjectKind.TABLE) {
            return null;
        }
        for (ResolveResult result2 : ((SqlReferenceExpression)e).multiResolve(true)) {
            if (!result2.isValidResult() || !(result2.getElement() instanceof DasTable)) continue;
            return (DasTable)result2.getElement();
        }
        return null;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        DatabaseDialectEx dialect;
        char quote;
        if (parameters == null) {
            SqlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(4);
        }
        if (!SqlCompletionUtil.isCompletionAllowed(parameters)) {
            return;
        }
        SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SqlPrefixedElement.class, (boolean)false);
        String prefix = StringUtil.notNullize((String)(prefixed == null ? null : prefixed.getNamePrefix()));
        String searchPrefix = result2.getPrefixMatcher().getPrefix();
        if (searchPrefix.length() > prefix.length() && ((quote = searchPrefix.charAt(prefix.length())) == (dialect = SqlImplUtil.getSqlDialectSafe(parameters.getPosition()).getDatabaseDialect()).openQuote() || quote == '\"')) {
            result2 = result2.withPrefixMatcher(prefix + result2.getPrefixMatcher().getPrefix().substring(prefix.length() + 1));
        }
        super.fillCompletionVariants(parameters, result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tuneReplacementOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

