/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.SqlQualifiedResolveResult;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionUtil {
    private static final ElementPattern<PsiElement> NUMERIC_LITERAL = PlatformPatterns.psiElement().withElementType((ElementPattern)PlatformPatterns.elementType().oneOf((Object[])new IElementType[]{SqlTokens.SQL_INTEGER_TOKEN, SqlTokens.SQL_FLOAT_TOKEN}));
    private static final String SELF = "SELF";

    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority) {
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(0);
        }
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(2);
        }
        return SqlCompletionUtil.addLookupElement(dialect, t, null, resultSet, addDot, forcePriority, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement psiElement) {
        void context;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(3);
        }
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(5);
        }
        return SqlCompletionUtil.addLookupElement(dialect, t, forcedContext, resultSet, addDot, forcePriority, (PsiElement)context, ContainerUtil.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement context, @NotNull Collection<SqlType> collection) {
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(6);
        }
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(8);
        }
        if (collection == null) {
            SqlCompletionUtil.$$$reportNull$$$0(9);
        }
        DatabaseDialectEx databaseDialect = dialect.getDatabaseDialect();
        if (t instanceof SqlAsExpression) {
            return SqlCompletionUtil.forAlias((SqlAsExpression)t, forcedContext, resultSet, databaseDialect, context);
        }
        if (t instanceof SqlFunctionDefinition) {
            return SqlCompletionUtil.forSqlFunction(dialect, (SqlFunctionDefinition)((Object)t), resultSet);
        }
        if (t instanceof DasRoutine && t instanceof PsiNamedElement) {
            return SqlCompletionUtil.forProcedureInfo((PsiNamedElement)t, resultSet, dialect, context);
        }
        if (t instanceof PsiNamedElement && !(t instanceof SqlReferenceExpression)) {
            void expectedSqlTypes;
            return SqlCompletionUtil.forPsiNamedElement((PsiNamedElement)t, forcedContext, resultSet, addDot, forcePriority, databaseDialect, context, (Collection<SqlType>)expectedSqlTypes);
        }
        if (t instanceof SqlReferenceExpression) {
            return SqlCompletionUtil.forSqlReference((SqlReferenceExpression)t, resultSet, context);
        }
        return false;
    }

    private static boolean forSqlReference(@NotNull SqlReferenceExpression r, @NotNull Consumer<? super LookupElement> resultSet, PsiElement context) {
        SqlIdentifier identifier;
        if (r == null) {
            SqlCompletionUtil.$$$reportNull$$$0(10);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(11);
        }
        String prefix = (identifier = r.getIdentifier()) == null ? null : identifier.getNamePrefix();
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)r).getDatabaseDialect();
        String name = r.getName();
        LookupElementBuilder builder = prefix != null ? LookupElementBuilder.create((String)(prefix + name)).withPresentableText(prefix + dialect.quoteIdentifier(name, false, false)).withInsertHandler(SqlInsertHandlers.createPrefixHandler(name, prefix, dialect)) : LookupElementBuilder.create((String)name);
        if (SqlCompletionUtil.canQualify(context)) {
            builder = builder.withInsertHandler(SqlInsertHandlers.chainHandlers(builder.getInsertHandler(), SqlInsertHandlers.createQualifierHandler(dialect)));
        }
        resultSet.consume((Object)builder);
        return true;
    }

    public static boolean canQualify(@Nullable IElementType elementType) {
        return elementType != SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE && elementType != SqlCompositeElementTypes.SQL_SHORT_REFERENCE;
    }

    public static boolean canQualify(@Nullable PsiElement element2) {
        return !(element2 instanceof SqlReferenceExpression) || SqlCompletionUtil.canQualify((IElementType)((SqlReferenceExpression)element2).getReferenceElementType());
    }

    private static boolean forSqlFunction(@NotNull SqlLanguageDialectEx dialect, @NotNull SqlFunctionDefinition f, @NotNull Consumer<? super LookupElement> resultSet) {
        SqlFunctionDefinition.Prototype[] prototypes;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(12);
        }
        if (f == null) {
            SqlCompletionUtil.$$$reportNull$$$0(13);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(14);
        }
        if ((prototypes = f.getPrototypes()).length == 0) {
            return false;
        }
        for (SqlFunctionDefinition.Prototype prototype : prototypes) {
            resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)1.0));
        }
        return true;
    }

    private static boolean forAlias(@NotNull SqlAsExpression t, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, @NotNull DatabaseDialect databaseDialect, @Nullable PsiElement context) {
        String name;
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(15);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(16);
        }
        if (databaseDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName((PsiNamedElement)t, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getAliasCase))))) {
            return false;
        }
        LookupElementBuilder item = LookupElementBuilder.create((Object)((Object)new SqlQualifiedResolveResult(forcedContext, (PsiElement)t)), (String)name).withInsertHandler(SqlInsertHandlers.getQuoteAndDotHandler((PsiNamedElement)t, databaseDialect, false, SqlCompletionUtil.isQuotedPlace(context)));
        if (forcedContext != null) {
            String qname;
            String string = qname = forcedContext instanceof DbDataSource || !(forcedContext instanceof DasObject) ? null : QNameUtil.getQualifiedName((DasObject)forcedContext);
            if (StringUtil.isNotEmpty(qname)) {
                item = item.withTailText(" (" + qname + ")", true);
            }
            if (SqlCompletionUtil.canQualify(context)) {
                item = item.withInsertHandler(SqlInsertHandlers.chainHandlers(item.getInsertHandler(), SqlInsertHandlers.createQualifierHandler((DatabaseDialectEx)databaseDialect)));
            }
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)item, (int)1), (double)10.0));
        return true;
    }

    public static void addReferenceCompletionVariants(@NotNull SqlReferenceImpl reference, @NotNull PrefixMatcher prefixMatcher, @NotNull Consumer<LookupElement> resultSet, @Nullable BiConsumer<? super DasObject, PsiElement> acceptedElementConsumer) {
        SqlExpression qualifierExpression;
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(18);
        }
        if (prefixMatcher == null) {
            SqlCompletionUtil.$$$reportNull$$$0(19);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(20);
        }
        SqlElement refElement = (SqlElement)reference.getElement();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)refElement);
        List<DbDataSource> dataSources2 = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getTopLevelSqlFile(refElement.getContainingFile()));
        CamelHumpMatcher adjustedMatcher = new CamelHumpMatcher(prefixMatcher.getPrefix(), false);
        boolean missingFrom = SqlCompletionUtil.hasMissingFrom(refElement);
        SqlExpression qualifier = reference.getQualifier();
        boolean filterPgRoutines = qualifier != null && dialect.getDbms().isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((PsiElement)refElement);
        SqlPrimitiveType qualifierType = filterPgRoutines ? qualifier.getSqlType() : SqlType.UNKNOWN;
        Set<ObjectKind> expectedTypesStrict = reference.getExpectedTargetTypesStrict(dialect);
        boolean addColumns = SqlCompletionUtil.shouldAddMissingColumns(reference);
        SqlCompletionScopeProcessor processor = new SqlCompletionScopeProcessor(dialect, dataSources2, refElement, addColumns, adjustedMatcher, resultSet, missingFrom, filterPgRoutines, (SqlType)qualifierType, expectedTypesStrict, acceptedElementConsumer);
        if (reference.initExpectedTargetTypes(processor)) {
            reference.processResolveVariants(processor);
        }
        dialect.processReservedEntitiesWithType(null, (PsiElement)refElement, false, processor);
        if (((SqlScopeProcessor)processor).isResultEmpty() && addColumns && (qualifierExpression = reference.getQualifierExpression()) instanceof SqlReferenceExpression && ((SqlReferenceExpression)qualifierExpression).resolve() == null) {
            Set<ObjectKind> expectedTypes = Collections.singleton(reference.getReferenceElementType().getTargetKind());
            ((SqlScopeProcessor)processor).handleEvent(SqlScopeProcessor.EXPECTED_TYPE, expectedTypes);
            reference.processUnqualifiedResolveVariants(processor, ResolveState.initial());
        }
    }

    public static boolean hasMissingFrom(SqlElement refElement) {
        boolean missingFrom = false;
        SqlQueryExpression closestSelect = (SqlQueryExpression)SyntaxTraverser.psiApi().parents((Object)refElement).filter(SqlQueryExpression.class).filter(q -> q.getSelectClause() != null).first();
        if (closestSelect != null) {
            SqlTableExpression tableExpression = closestSelect.getTableExpression();
            missingFrom = tableExpression == null || tableExpression.getFromClause() == null;
        }
        return missingFrom;
    }

    private static boolean shouldAddMissingColumns(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(21);
        }
        if (reference.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), SqlQueryExpression.class);
        if (query == null) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)query.getSelectClause(), (PsiElement)reference.getElement(), (boolean)true)) {
            return false;
        }
        SqlTableExpression tableExpression = query.getTableExpression();
        SqlFromClause fromClause = tableExpression != null ? tableExpression.getFromClause() : null;
        return fromClause == null || fromClause.getFromExpression() == null;
    }

    public static boolean isCompletionAllowed(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(22);
        }
        if (!parameters.isAutoPopup()) {
            return true;
        }
        int offset = parameters.getOffset() - 1;
        PsiFile file = parameters.getOriginalFile();
        PsiElement element2 = offset >= 0 && offset < file.getTextLength() ? file.findElementAt(offset) : null;
        return element2 == null || !NUMERIC_LITERAL.accepts((Object)element2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean forPsiNamedElement(@NotNull PsiNamedElement o, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @NotNull DatabaseDialect databaseDialect, @Nullable PsiElement element2, @NotNull Collection<SqlType> collection) {
        void expectedSqlTypes;
        DasObject context;
        String name;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(23);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(24);
        }
        if (databaseDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(25);
        }
        if (collection == null) {
            SqlCompletionUtil.$$$reportNull$$$0(26);
        }
        if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName(o, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getIdentifierCase))))) {
            return false;
        }
        Icon icon = o instanceof PsiPresentableMetaData ? ((PsiPresentableMetaData)o).getIcon() : o.getIcon(0);
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)((Object)new SqlQualifiedResolveResult(forcedContext, (PsiElement)o)), (String)name).withTypeText(SqlCompletionUtil.typeText(o)).withInsertHandler(SqlInsertHandlers.getQuoteAndDotHandler(o, databaseDialect, addDot, SqlCompletionUtil.isQuotedPlace(element2))).withIcon(icon);
        String prefix = SqlCompletionUtil.getPrefix(o);
        if (prefix != null) {
            lookup = lookup.withPresentableText(prefix + databaseDialect.quoteIdentifier(o.getName(), false, false));
        }
        if (name.contains(" ")) {
            lookup = lookup.withLookupString(name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")).withLookupString(name.replaceAll(" ", "_"));
        }
        DasObject dasObject = context = forcedContext == null && o instanceof DasObject ? ((DasObject)o).getDasParent() : (DasObject)ObjectUtils.tryCast((Object)forcedContext, DasObject.class);
        if (context != null) {
            String qname;
            String string = qname = context instanceof DbDataSource ? null : QNameUtil.getQualifiedName(context);
            if (StringUtil.isNotEmpty((String)qname)) {
                lookup = lookup.withTailText(" (" + qname + ")", true);
            }
        }
        double priority = SqlCompletionUtil.isTypeMatch(o, (Collection<SqlType>)expectedSqlTypes) ? 150.0 : (o instanceof DbElement ? 5.0 : 10.0);
        for (DasObject cur = (DasObject)ObjectUtils.tryCast((Object)o, DasObject.class); cur != null; cur = cur.getDasParent()) {
            priority += 0.1;
        }
        if (SqlCompletionUtil.canQualify(element2)) {
            lookup = lookup.withInsertHandler(SqlInsertHandlers.chainHandlers(lookup.getInsertHandler(), SqlInsertHandlers.createQualifierHandler((DatabaseDialectEx)databaseDialect)));
        }
        if (o instanceof DasTable && o.getName() != null && element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getReferenceElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && SqlCodeCompletionSettings.getInstance().isAutoAliasTable() && !SqlCompletionUtil.skipAlias(element2)) {
            lookup = lookup.withPresentableText(lookup.getLookupString() + " " + SqlNamesGenerator.suggestAliasName(o.getName(), element2)).withInsertHandler(SqlInsertHandlers.chainHandlers(lookup.getInsertHandler(), SqlInsertHandlers.ADD_TABLE_ALIAS_HANDLER));
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)Math.max(forcePriority, priority)));
        return true;
    }

    private static boolean skipAlias(@NotNull PsiElement element2) {
        SqlInsertDmlInstruction insert;
        if (element2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(27);
        }
        if ((insert = (SqlInsertDmlInstruction)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlInsertDmlInstruction.class})) != null && PsiTreeUtil.isAncestor((PsiElement)insert.getColumnsList(), (PsiElement)element2, (boolean)true)) {
            return true;
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlAlterStatement.class}) != null;
    }

    private static boolean isQuotedPlace(@Nullable PsiElement element2) {
        return element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).isQuotedIdentifier();
    }

    private static boolean isTypeMatch(@NotNull PsiNamedElement o, @NotNull Collection<SqlType> expectedSqlTypes) {
        SqlType ownType;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(28);
        }
        if (expectedSqlTypes == null) {
            SqlCompletionUtil.$$$reportNull$$$0(29);
        }
        if (o instanceof DasColumn && (DasUtil.isPrimary((DasColumn)((DasColumn)o)) || DasUtil.isForeign((DasColumn)((DasColumn)o)))) {
            return false;
        }
        SqlType sqlType = ownType = o instanceof DasTypedObject ? SqlImplUtil.getSqlType((DasTypedObject)o, SqlImplUtil.getSqlDialectSafe((PsiElement)o), (PsiElement)o) : null;
        if (ownType == null || expectedSqlTypes.size() == 0) {
            return false;
        }
        return expectedSqlTypes.stream().anyMatch(t -> SqlFunctionsUtil.isAssignable(t, ownType));
    }

    @Nullable
    private static String calcName(@NotNull PsiNamedElement o, @NotNull Function<? super PsiFile, Case> plainCaseGetter) {
        String roughName;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(30);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(31);
        }
        return StringUtil.isEmpty((String)(roughName = SqlCompletionUtil.roughName(o))) ? null : SqlCompletionUtil.getMode(o.getContainingFile(), o, plainCaseGetter).apply(roughName);
    }

    @NotNull
    private static Case getMode(@Nullable PsiFile file, @NotNull PsiNamedElement o, @NotNull Function<? super PsiFile, Case> plainCaseGetter) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(32);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(33);
        }
        Case case_ = SqlCompletionUtil.hasPlainIdentifier((PsiElement)o) ? (Case)plainCaseGetter.fun((Object)file) : SqlPsiMiscUtil.getQuotedIdentifierCase(file);
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(34);
        }
        return case_;
    }

    public static boolean hasPlainIdentifier(PsiElement t) {
        if (t instanceof DasObject) {
            DasObject obj = (DasObject)t;
            boolean isSql = DbSqlUtil.isSqlObject(obj);
            if (isSql) {
                return !DbSqlUtil.isQuoted(obj);
            }
            DatabaseDialectEx dialect = t instanceof DbElement ? DbImplUtil.getDatabaseDialect((DbElement)t) : DatabaseDialects.getGenericDialect();
            String id = dialect.quoteIdentifier(obj.getName(), false, false);
            return !dialect.isQuotedIdentifier(id);
        }
        if (t instanceof SqlNameElement) {
            return !DbSqlUtil.isQuoted((SqlNameElement)t);
        }
        return false;
    }

    @Nullable
    private static String roughName(@NotNull PsiNamedElement o) {
        String origin;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(35);
        }
        if (o instanceof SqlFileImpl.FakeDefinition && (origin = ((SqlFileImpl.FakeDefinition)o).getOriginalName()) != null) {
            return origin;
        }
        String prefix = SqlCompletionUtil.getPrefix(o);
        return prefix == null ? o.getName() : prefix + o.getName();
    }

    @Nullable
    private static String typeText(@NotNull PsiNamedElement t) {
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(36);
        }
        if (t instanceof DasTypedObject) {
            return JdbcUtil.getJdbcTypeName((DataType)((DasTypedObject)t).getDataType());
        }
        if (t instanceof SqlFileImpl.FakeDefinition) {
            return ((SqlFileImpl.FakeDefinition)t).getTypeName();
        }
        if (t instanceof DbElement) {
            return ((DbElement)t).getDataSource().getName();
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)t);
        return file == null ? t.getName() : VfsPresentationUtil.getPresentableNameForUI((Project)t.getProject(), (VirtualFile)file);
    }

    @Nullable
    static SqlPrefixedElement getPrefixed(@NotNull PsiNamedElement o) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(37);
        }
        return (SqlPrefixedElement)ObjectUtils.tryCast((Object)(o instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)o).getNameIdentifier() : o), SqlPrefixedElement.class);
    }

    @Nullable
    private static String getPrefix(@NotNull PsiNamedElement o) {
        SqlPrefixedElement prefixed;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(38);
        }
        return (prefixed = SqlCompletionUtil.getPrefixed(o)) == null ? null : prefixed.getNamePrefix();
    }

    private static boolean forProcedureInfo(@NotNull PsiNamedElement o, @NotNull Consumer<? super LookupElement> resultSet, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement context) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(39);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(40);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(41);
        }
        LookupElement procedureLookup = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(o.getProject(), (DasRoutine)o, dialect, context), (double)0.0);
        resultSet.consume((Object)procedureLookup);
        return true;
    }

    @NotNull
    public static LookupElement createEntityLookupItem(@NotNull PsiFile psiFile, @NotNull String entityName, @NotNull SqlType type, @NotNull ObjectKind kind, boolean forcedCaseSens) {
        if (psiFile == null) {
            SqlCompletionUtil.$$$reportNull$$$0(42);
        }
        if (entityName == null) {
            SqlCompletionUtil.$$$reportNull$$$0(43);
        }
        if (type == null) {
            SqlCompletionUtil.$$$reportNull$$$0(44);
        }
        if (kind == null) {
            SqlCompletionUtil.$$$reportNull$$$0(45);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(forcedCaseSens ? entityName : SqlPsiMiscUtil.getIdentifierCase(psiFile).apply(entityName))).bold().withTypeText(SqlCompletionUtil.getTypeText(type, kind)).withIcon(DbPresentation.getIcon(kind));
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(46);
        }
        return lookupElementBuilder;
    }

    @Nullable
    private static String getTypeText(@NotNull SqlType type, @NotNull ObjectKind kind) {
        if (type == null) {
            SqlCompletionUtil.$$$reportNull$$$0(47);
        }
        if (kind == null) {
            SqlCompletionUtil.$$$reportNull$$$0(48);
        }
        if (type instanceof SqlTableType) {
            return null;
        }
        return type != SqlTypeFactory.REFERENCE ? type.getDisplayName() : StringUtil.toLowerCase((String)kind.name());
    }

    @NotNull
    public static LookupElementBuilder createLookupItem(@NotNull String str, boolean boldness, boolean caseSensitivity, @Nullable InsertHandler<LookupElement> handler, @NotNull Collection<String> aliases) {
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(49);
        }
        if (aliases == null) {
            SqlCompletionUtil.$$$reportNull$$$0(50);
        }
        LookupElementBuilder element2 = LookupElementBuilder.create((String)str).withBoldness(boldness).withCaseSensitivity(caseSensitivity).withInsertHandler(handler);
        LookupElementBuilder lookupElementBuilder = aliases.isEmpty() ? element2 : element2.withLookupStrings(aliases);
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(51);
        }
        return lookupElementBuilder;
    }

    private static boolean isAlterTarget(@Nullable PsiElement element2) {
        SqlAlterStatement alter = (SqlAlterStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAlterStatement.class);
        return alter != null && PsiTreeUtil.isContextAncestor((PsiElement)alter.getAlterTargetReference(), (PsiElement)element2, (boolean)false);
    }

    public static boolean isModificationTarget(@Nullable PsiElement element2) {
        return SqlPsiMiscUtil.isDropTarget(element2) || SqlCompletionUtil.isAlterTarget(element2);
    }

    public static LookupElement createLookupItem(@NotNull Project project, @NotNull DasRoutine def, @NotNull SqlLanguageDialectEx sqlDialect, @Nullable PsiElement context) {
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(52);
        }
        if (def == null) {
            SqlCompletionUtil.$$$reportNull$$$0(53);
        }
        if (sqlDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(54);
        }
        @NotNull DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
        Iterable<? extends DasArgument> parameters = SqlCompletionUtil.getSignatureArguments(def, dialect);
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder identifier(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                DdlBuilder ddlBuilder = this.plain(name);
                if (ddlBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ddlBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/SqlCompletionUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.withDialect(dialect).applyCodeStyle(project);
        builder.identifier(def.getName());
        String name = builder.getStatement();
        boolean isModificationTarget = SqlCompletionUtil.isModificationTarget(context);
        boolean supportsOverloads = dialect.getDbms().isPostgres();
        boolean noParensCall = dialect.getDbms().isMicrosoft() && PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectClause.class) == null;
        boolean modificationNoOverloads = isModificationTarget && !supportsOverloads;
        boolean useSpaces = noParensCall || modificationNoOverloads;
        boolean noParams = Iterables.isEmpty(parameters) || modificationNoOverloads;
        String parametersText = SqlCompletionUtil.addParametersText(builder.clear(), parameters, useSpaces).getStatement();
        String returnTypeText = SqlPsiMiscUtil.addReturnTypeText(builder.clear(), def.getReturnArgument()).getStatement();
        SqlFunctionDefinition definition = sqlDialect.getSupportedFunctions().get(name);
        return LookupElementBuilder.create((Object)def, (String)name).withIcon(DatabaseIcons.Function).withPresentableText(name + parametersText).withTypeText(returnTypeText).withInsertHandler((InsertHandler)new SqlInsertHandlers.FunctionElementInsertHandler(dialect.getDbms(), useSpaces, noParams, isModificationTarget && supportsOverloads ? parametersText : null, definition, SqlCompletionUtil.findMatchingPrototype(def, definition)));
    }

    @Nullable
    private static SqlFunctionDefinition.Prototype findMatchingPrototype(@NotNull DasRoutine def, @Nullable SqlFunctionDefinition definition) {
        if (def == null) {
            SqlCompletionUtil.$$$reportNull$$$0(55);
        }
        if (definition == null) {
            return null;
        }
        Iterable arguments = def.getArguments();
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            Iterator iterator = arguments.iterator();
            boolean match2 = true;
            for (SqlFunctionDefinition.Parameter param : prototype.getParams()) {
                DataType type2;
                if (!(param instanceof SqlFunctionDefinition.SimpleParameter) || !iterator.hasNext()) {
                    match2 = false;
                    break;
                }
                DasArgument argument = (DasArgument)iterator.next();
                DataType type = argument.getDataType();
                if (type.equals(type2 = ((SqlFunctionDefinition.SimpleParameter)param).getType().getDataType())) continue;
                match2 = false;
                break;
            }
            if (!match2 || iterator.hasNext()) continue;
            return prototype;
        }
        return null;
    }

    @NotNull
    private static Iterable<? extends DasArgument> getSignatureArguments(@NotNull DasRoutine def, @NotNull DatabaseDialectEx dialect) {
        DasArgument argument;
        Iterator iterator;
        if (def == null) {
            SqlCompletionUtil.$$$reportNull$$$0(56);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(57);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)def);
        if (dialect.getDbms().isOracle() && (iterator = def.getArguments().iterator()).hasNext() && SELF.equalsIgnoreCase((argument = (DasArgument)iterator.next()).getName())) {
            parameters = parameters.skip(1);
        }
        JBIterable jBIterable = parameters;
        if (jBIterable == null) {
            SqlCompletionUtil.$$$reportNull$$$0(58);
        }
        return jBIterable;
    }

    @NotNull
    public static DdlBuilder addParametersText(@NotNull DdlBuilder builder, @NotNull Iterable<? extends DasArgument> parameters, boolean useSpaces) {
        if (builder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(59);
        }
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(60);
        }
        builder.symbol(useSpaces ? " " : "(");
        boolean first = true;
        for (DasArgument dasArgument : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            String name = dasArgument.getName();
            if (name != DasUtil.NO_NAME) {
                builder.identifier(name).symbol(" ");
            }
            builder.type((DasTypedObject)dasArgument);
        }
        builder.symbol(useSpaces ? "" : ")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(61);
        }
        return ddlBuilder;
    }

    public static LookupElement createLookupItem(final @NotNull SqlFunctionDefinition.Prototype prototype, @NotNull SqlLanguageDialect dialect) {
        if (prototype == null) {
            SqlCompletionUtil.$$$reportNull$$$0(62);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(63);
        }
        return LookupElementBuilder.create((Object)prototype, (String)prototype.getFunction().getName()).withCaseSensitivity(false).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(1);
                }
                presentation.setIcon(DatabaseIcons.Function);
                presentation.setItemText(element2.getLookupString());
                String params = new SqlFunctionDefinition.ParameterBlock(-1, prototype.getBlockType(), prototype.getParams(), false).toString();
                presentation.appendTailText(params, true);
                presentation.setTypeText(prototype.getReturnType().getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionUtil$2";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).withInsertHandler((InsertHandler)new SqlInsertHandlers.FunctionElementInsertHandler(dialect.getDbms(), ((SqlLanguageDialectEx)dialect).canBeCalledWithoutParens(prototype), prototype.getParams().length == 0, null, prototype.getFunction(), prototype));
    }

    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction) {
        if (keywordCase == null) {
            SqlCompletionUtil.$$$reportNull$$$0(64);
        }
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(65);
        }
        LookupElement lookupElement = SqlCompletionUtil.createKeywordLookupElement(keywordCase, str, handler, correction, ContainerUtil.emptyList());
        if (lookupElement == null) {
            SqlCompletionUtil.$$$reportNull$$$0(66);
        }
        return lookupElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction, @NotNull Collection<String> collection) {
        void aliases;
        if (keywordCase == null) {
            SqlCompletionUtil.$$$reportNull$$$0(67);
        }
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(68);
        }
        if (collection == null) {
            SqlCompletionUtil.$$$reportNull$$$0(69);
        }
        boolean caseSensitive = keywordCase == Case.UPPER || keywordCase == Case.LOWER;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(keywordCase.apply(str), true, caseSensitive, handler, (Collection<String>)aliases), (double)(5.0 + correction));
        if (lookupElement == null) {
            SqlCompletionUtil.$$$reportNull$$$0(70);
        }
        return lookupElement;
    }

    public static void addItemsFromExpectedColumnType(@NotNull Consumer<? super LookupElement> consumer2, @NotNull DasColumn column2, @NotNull PsiElement place) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(71);
        }
        if (column2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(72);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(73);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(place);
        if (SqlCompletionUtil.addValuesFromDataType(consumer2, column2.getDataType(), place instanceof SqlStringLiteralExpression, dialect)) {
            return;
        }
        SqlType type = SqlCompletionUtil.getColumnSqlType(column2, place);
        SqlCompletionUtil.addItemsFromExpectedColumnType(consumer2, place, type, dialect);
    }

    public static void addItemsFromExpectedColumnType(@NotNull Consumer<? super LookupElement> consumer2, @NotNull PsiElement place, @NotNull SqlType type, SqlLanguageDialectEx dialect) {
        boolean quoted;
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(74);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(75);
        }
        if (type == null) {
            SqlCompletionUtil.$$$reportNull$$$0(76);
        }
        if (!(quoted = place instanceof SqlStringLiteralExpression) && type.getCategory() == SqlType.Category.BOOLEAN) {
            SqlCompletionUtil.addTrueFalse(consumer2);
            return;
        }
        SqlCompletionUtil.addValuesFromDataType(consumer2, type.getDataType(), quoted, dialect);
    }

    private static void addTrueFalse(@NotNull Consumer<? super LookupElement> consumer2) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(77);
        }
        consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"true").withBoldness(true), (double)150.0));
        consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"false").withBoldness(true), (double)150.0));
    }

    private static boolean addValuesFromDataType(@NotNull Consumer<? super LookupElement> consumer2, DataType dataType, boolean quoted, SqlLanguageDialectEx dialect) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(78);
        }
        if (!quoted && ("boolean".equals(dataType.typeName) || "bool".equals(dataType.typeName))) {
            SqlCompletionUtil.addTrueFalse(consumer2);
            return true;
        }
        List enumValues = dataType.enumValues;
        if (enumValues != null) {
            boolean added = false;
            for (String enumValue : enumValues) {
                enumValue = SqlCompletionUtil.fixEnumValue(enumValue, quoted, dialect);
                consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)enumValue), (double)150.0));
                added = true;
            }
            return added;
        }
        return false;
    }

    @NotNull
    private static SqlType getColumnSqlType(@NotNull DasColumn column2, @NotNull PsiElement place) {
        if (column2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(79);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(80);
        }
        SqlType sqlType = SqlImplUtil.getSqlType(place.getProject(), column2.getDataType(), SqlImplUtil.getSqlDialectSafe(place), place);
        if (sqlType == null) {
            SqlCompletionUtil.$$$reportNull$$$0(81);
        }
        return sqlType;
    }

    @NotNull
    private static String fixEnumValue(@NotNull String enumValue, boolean insideLiteral, SqlLanguageDialectEx dialect) {
        int quote;
        int eq;
        if (enumValue == null) {
            SqlCompletionUtil.$$$reportNull$$$0(82);
        }
        if (dialect.getDbms().isClickHouse() && (eq = enumValue.indexOf(61, (quote = (quote = enumValue.indexOf(39)) == -1 ? -1 : enumValue.indexOf(39, quote + 1)) == -1 ? 0 : quote)) != -1) {
            enumValue = enumValue.substring(0, eq).trim();
        }
        if (!insideLiteral && !StringUtil.isQuotedString((String)enumValue)) {
            String string = '\'' + enumValue + '\'';
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(83);
            }
            return string;
        }
        if (insideLiteral && StringUtil.isQuotedString((String)enumValue)) {
            String string = StringUtil.unquoteString((String)enumValue, (char)'\'');
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(84);
            }
            return string;
        }
        String string = enumValue;
        if (string == null) {
            SqlCompletionUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    @Nullable
    public static LookupElement createAllColumnsLookupElement(@NotNull Iterable<? extends DasObject> columns, @NotNull DatabaseDialectEx dialect, int priority, boolean parenthesized, boolean canQualify, List<PsiElement> qualifiers) {
        if (columns == null) {
            SqlCompletionUtil.$$$reportNull$$$0(86);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(87);
        }
        DdlBuilder classic = new DdlBuilder().withDialect(dialect);
        DasObject last = null;
        HashSet names = ContainerUtil.newHashSet();
        HashSet parentNames = ContainerUtil.newHashSet();
        for (DasObject dasObject : columns) {
            if (names.size() != 0) {
                classic.symbol(",").space();
            }
            classic.suppressQuoteIdentifiers(!DbSqlUtil.isQuoted(dasObject));
            String name = null;
            if (dasObject instanceof PsiNamedElement) {
                name = SqlCompletionUtil.calcName((PsiNamedElement)dasObject, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getIdentifierCase));
            }
            if (name == null) {
                name = dasObject.getName();
            }
            names.add(name);
            classic.columnRef(name);
            parentNames.add(QNameUtil.getQualifiedName(dasObject.getDasParent()));
            last = dasObject;
        }
        if (last == null || names.size() == 1) {
            return null;
        }
        String statement = classic.getStatement();
        if (statement.isEmpty()) {
            return null;
        }
        InsertHandler<LookupElement> insertHandler = canQualify ? SqlInsertHandlers.createQualifierHandler(dialect, true, qualifiers) : SqlInsertHandlers.DUMMY_HANDLER;
        String parentName = String.join((CharSequence)", ", parentNames);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create(last, (String)statement).withIcon(IconHolder.ourColumnColumnIcon).withLookupStrings((Collection)names).withCaseSensitivity(false).withTailText(StringUtil.isEmpty((String)parentName) ? "" : " (" + parentName + ")", true).withInsertHandler(parenthesized ? SqlInsertHandlers.chainHandlers(SqlInsertHandlers.ADD_RPAREN_LOOKUP_HANDLER, insertHandler) : insertHandler), (double)priority);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 46: 
            case 51: 
            case 58: 
            case 61: 
            case 66: 
            case 70: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 46: 
            case 51: 
            case 58: 
            case 61: 
            case 66: 
            case 70: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 20: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 9: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedSqlTypes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 22: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainCaseGetter";
                break;
            }
            case 34: 
            case 46: 
            case 51: 
            case 58: 
            case 61: 
            case 66: 
            case 70: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/SqlCompletionUtil";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 44: 
            case 47: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 49: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 50: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 53: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordCase";
                break;
            }
            case 71: 
            case 74: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 73: 
            case 75: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumValue";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/SqlCompletionUtil";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntityLookupItem";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItem";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureArguments";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "addParametersText";
                break;
            }
            case 66: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordLookupElement";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnSqlType";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "fixEnumValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forSqlReference";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forSqlFunction";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forAlias";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceCompletionVariants";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddMissingColumns";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCompletionAllowed";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forPsiNamedElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "skipAlias";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isTypeMatch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMode";
                break;
            }
            case 34: 
            case 46: 
            case 51: 
            case 58: 
            case 61: 
            case 66: 
            case 70: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "roughName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "typeText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixed";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "forProcedureInfo";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createEntityLookupItem";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingPrototype";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureArguments";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addParametersText";
                break;
            }
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addItemsFromExpectedColumnType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addTrueFalse";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addValuesFromDataType";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getColumnSqlType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "fixEnumValue";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createAllColumnsLookupElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 34: 
            case 46: 
            case 51: 
            case 58: 
            case 61: 
            case 66: 
            case 70: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconHolder {
        private static final Icon ourColumnColumnIcon = IconHolder.createColumnColumnIcon();

        private IconHolder() {
        }

        @NotNull
        private static Icon createColumnColumnIcon() {
            int w = DatabaseIcons.Col.getIconWidth();
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(DatabaseIcons.Col, 0, 2 * w / 5, 0);
            icon.setIcon(DatabaseIcons.Col, 1);
            LayeredIcon layeredIcon = icon;
            if (layeredIcon == null) {
                IconHolder.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionUtil$IconHolder", "createColumnColumnIcon"));
        }
    }
}

