/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.database.model.DataType;
import com.intellij.sql.dialects.base.EvaluationHelperBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/dialects/cassandra/CassandraEvaluationHelper;", "Lcom/intellij/sql/dialects/base/EvaluationHelperBase;", "()V", "generateSelectStatement", "", "text", "sqlElement", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.sql.dialects"})
public final class CassandraEvaluationHelper
extends EvaluationHelperBase {
    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text2, @NotNull SqlElement sqlElement) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)sqlElement, (String)"sqlElement");
        if (sqlElement instanceof SqlTypeCastExpression) {
            return "SELECT " + text2 + " FROM system.local";
        }
        String type = "???";
        if (sqlElement instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)sqlElement).getSqlType();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlType, (String)"sqlElement.sqlType");
            SqlType sqlType2 = sqlType;
            if (sqlType2 instanceof SqlPrimitiveType && Intrinsics.areEqual((Object)sqlType2, (Object)SqlType.UNKNOWN) ^ true) {
                String string = sqlType2.getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sqlType.getDisplayName()");
                type = string;
            } else if (sqlType2 instanceof SqlParametrizedType) {
                DataType dataType = ((SqlParametrizedType)sqlType2).getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sqlType.dataType");
                String string = dataType.getSpecification();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sqlType.dataType.specification");
                type = string;
            }
        }
        return "SELECT (" + type + ") " + text2 + " FROM system.local";
    }
}

