/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mssql.MssqlExpressionParsing;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;

public class MssqlGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean parseExecArgument(PsiBuilder builder, int level) {
        SqlParser parser = MssqlGeneratedParserUtil.getParser(builder);
        PsiBuilder.Marker mark2 = builder.mark();
        boolean parsed = parser.parseNamedFunctionArgumentPrefixImpl(builder, (IElementType)SqlTokens.SQL_OP_EQ);
        boolean parsedVal = MssqlGeneratedParserUtil.parseExecArgumentValue(parser, builder, level, !parsed);
        if (parsed) {
            mark2.done((IElementType)SqlCompositeElementTypes.SQL_NAMED_PARAMETER_VALUE);
        } else {
            mark2.drop();
        }
        return parsed || parsedVal;
    }

    private static boolean parseExecArgumentValue(SqlParser parser, PsiBuilder builder, int level, boolean optional) {
        boolean res2 = MssqlExpressionParsing.literal_expr(builder, level);
        res2 = res2 || parser.parseReferenceExpressionOrVariable(builder, SqlCompositeElementTypes.SQL_SHORT_REFERENCE);
        boolean bl = res2 = res2 || MssqlGeneratedParserUtil.parseNoArgCall(parser, builder);
        if (!optional && !res2) {
            GeneratedParserUtilBase.report_error_((PsiBuilder)builder, (boolean)false);
        }
        return res2;
    }

    private static boolean parseNoArgCall(SqlParser parser, PsiBuilder builder) {
        SqlFunctionDefinition foo;
        String text2 = builder.getTokenText();
        SqlFunctionDefinition sqlFunctionDefinition = foo = text2 == null ? null : parser.getLanguage().getSupportedFunctions().get(StringUtil.toUpperCase((String)text2));
        if (foo == null) {
            return false;
        }
        boolean noArg = false;
        for (SqlFunctionDefinition.Prototype prototype : foo.getPrototypes()) {
            if (!parser.getLanguage().canBeCalledWithoutParens(prototype)) continue;
            noArg = true;
            break;
        }
        if (noArg) {
            PsiBuilder.Marker ref = builder.mark();
            builder.advanceLexer();
            ref.done((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER);
            ref = ref.precede();
            ref.done((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE);
            builder.mark().done((IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST);
            ref.precede().done((IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL);
        }
        return noArg;
    }

    public static boolean isTimestampColumn(PsiBuilder builder, int level) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker == null || marker.getTokenType() != SqlCompositeElementTypes.SQL_IDENTIFIER) {
            return false;
        }
        int s = marker.getStartOffset();
        int e = marker.getEndOffset();
        CharSequence text2 = builder.getOriginalText();
        text2 = text2.subSequence(s, e);
        String identifier = MssqlGeneratedParserUtil.getParser(builder).getLanguage().getDatabaseDialect().unquoteIdentifier(text2.toString());
        return StringUtil.equalsIgnoreCase((CharSequence)identifier, (CharSequence)"timestamp");
    }
}

