/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.ElementTypeSetPattern;
import com.intellij.sql.formatter.model.EndIncElementPattern;
import com.intellij.sql.formatter.model.EndObjectKindPattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.SingleElementPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTableParenthesizedColumnsSection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\nJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "()V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getNewLineIdent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "whetherToFlatten", "Companion", "TableHeaderSection", "intellij.database.sql.impl"})
public final class SqlCreateTableBlock
extends SqlDdlStatementBlock {
    @NotNull
    private static final Map<IElementType, FlowPattern> patterns;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node.getElementType() == SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE) return true;
        SqlFormattingContext sqlFormattingContext = this.getContext();
        Dbms dbms = Dbms.SQLITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.SQLITE");
        if (!sqlFormattingContext.isDialect(dbms)) return false;
        if (node.getElementType() == SqlCompositeElementTypes.SQL_CLAUSE) return true;
        if (!Intrinsics.areEqual((Object)node.getElementType().toString(), (Object)"SQL_MODULE_REFERENCE")) return false;
        return true;
    }

    @Override
    @NotNull
    protected Map<IElementType, FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        String string = node.getElementType().toString();
        switch (string.hashCode()) {
            case 200314079: {
                if (string.equals("PG_INHERITS_TABLE_CLAUSE")) {
                    void $receiver$iv;
                    SqlRangeBlock sqlRangeBlock = new SqlPostfixClauseBlock();
                    SqlBlock parent$iv = this;
                    TextRange textRange = node.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"outerNode.textRange");
                    $receiver$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
                    sqlBlock = sqlRangeBlock;
                    break;
                }
            }
            default: {
                sqlBlock = super.makeBlock(node);
            }
        }
        return sqlBlock;
    }

    @Override
    protected void configureFormattingAttributes() {
        Object v7;
        SqlBlock it;
        Object t;
        Object $i$a$1$also;
        Object it2;
        Object object;
        Wrap w;
        block23: {
            SqlBlock asWord;
            SqlBlock sqlBlock;
            Object $receiver$iv;
            block22: {
                Object v0;
                Object object2;
                Indent i2;
                int openingSetting;
                block20: {
                    Iterable iterable;
                    openingSetting = this.getContext().getSql().TABLE_OPENING;
                    w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.getContext().getSql().TABLE_COLLAPSE ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS, false, 2, null);
                    i2 = openingSetting == 4 ? Indent.getNormalIndent((boolean)true) : SqlFormattingFunKt.getNONE_INDENT();
                    Iterable iterable2 = iterable = (Iterable)this.getNestedBlocks();
                    object = iterable2.iterator();
                    while (object.hasNext()) {
                        object2 = object.next();
                        it2 = (SqlBlock)object2;
                        if (!(it2 instanceof SqlTableParenthesizedColumnsSection)) continue;
                        v0 = object2;
                        break block20;
                    }
                    v0 = null;
                }
                SqlBlock columnSection = v0;
                if (columnSection != null) {
                    if (this.getContext().getSql().TABLE_OPENING == 3) {
                        Object v3;
                        Object v2;
                        Alignment sectionAlignment;
                        block21: {
                            sectionAlignment = SqlFormattingModelFunKt.makeLeftAlignment();
                            SqlBlock sqlBlock2 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
                            if (sqlBlock2 != null) {
                                sqlBlock2.setMyAlign(sectionAlignment);
                            }
                            object2 = object = ($receiver$iv = (Iterable)this.getNestedBlocks());
                            for (Object $i$a$1$find : object2) {
                                SqlBlock it$iv = (SqlBlock)$i$a$1$find;
                                if (!(it$iv instanceof SqlTableParenthesizedColumnsSection)) continue;
                                v2 = $i$a$1$find;
                                break block21;
                            }
                            v2 = v3 = null;
                        }
                        if (!(v2 instanceof SqlTableParenthesizedColumnsSection)) {
                            v3 = null;
                        }
                        SqlTableParenthesizedColumnsSection sqlTableParenthesizedColumnsSection = v3;
                        if (sqlTableParenthesizedColumnsSection != null) {
                            sqlTableParenthesizedColumnsSection.setSectionAlignment(sectionAlignment);
                        }
                    }
                    columnSection.setMyIndent(i2);
                    columnSection.setMyWrap((Wrap)(openingSetting > 1 ? w : null));
                }
                object = $receiver$iv = (Iterable)this.getNestedBlocks();
                object2 = object.iterator();
                while (object2.hasNext()) {
                    it2 = object2.next();
                    Object it3 = it2;
                    if (!(it3 instanceof SqlKeyword && ((SqlKeyword)it3).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    sqlBlock = it2;
                    break block22;
                }
                sqlBlock = null;
            }
            SqlBlock sqlBlock3 = asWord = (SqlBlock)sqlBlock;
            if (sqlBlock3 != null) {
                Object it4 = $receiver$iv = sqlBlock3;
                ((SqlBlock)it4).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
                ((SqlBlock)it4).setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
            $i$a$1$also = object = (Iterable)this.getNestedBlocks();
            it2 = $i$a$1$also.iterator();
            while (it2.hasNext()) {
                t = it2.next();
                it = (SqlBlock)t;
                if (!(it instanceof SqlQueryBlock || it instanceof SqlParenthesizedSubqueryBlock)) continue;
                v7 = t;
                break block23;
            }
            v7 = null;
        }
        SqlBlock querySection = v7;
        if (querySection != null) {
            Object v8;
            block24: {
                $i$a$1$also = object = (Iterable)this.getNestedBlocks();
                it2 = $i$a$1$also.iterator();
                while (it2.hasNext()) {
                    t = it2.next();
                    it = (SqlBlock)t;
                    if (!(it instanceof SqlKeyword && ((SqlKeyword)it).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    v8 = t;
                    break block24;
                }
                v8 = null;
            }
            SqlBlock sqlBlock = v8;
            if (sqlBlock != null) {
                Object it5 = object = sqlBlock;
                ((SqlBlock)it5).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
            }
            object = querySection;
            if (object instanceof SqlQueryBlock) {
                querySection.setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_QUERY ? w : null));
                querySection.setMyIndent(this.getContext().getSql().VIEW_INDENT_QUERY ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
            } else if (object instanceof SqlParenthesizedSubqueryBlock) {
                Indent indent;
                querySection.setMyWrap((Wrap)(this.getContext().getSql().SUBQUERY_OPENING > 1 ? w : null));
                switch (this.getContext().getSql().SUBQUERY_OPENING) {
                    case 3: {
                        indent = Indent.getSpaceIndent((int)0, (boolean)true);
                        break;
                    }
                    case 4: {
                        indent = Indent.getNormalIndent((boolean)true);
                        break;
                    }
                    default: {
                        indent = SqlFormattingFunKt.getNORMAL_INDENT();
                    }
                }
                querySection.setMyIndent(indent);
            }
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (this.getShape().getCollapsing()) {
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
        if (block2 instanceof SqlTableParenthesizedColumnsSection) {
            switch (this.getContext().getSql().TABLE_OPENING) {
                case 1: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean userRequiresExpand() {
        return !this.getContext().getSql().TABLE_COLLAPSE;
    }

    @Override
    @Nullable
    public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        return blocks.getBlock2() instanceof SqlTableParenthesizedColumnsSection ? SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, this.getContext().getSql().TABLE_OPENING == 4, 2, null) : super.getNewLineIdent(blocks);
    }

    static {
        Companion = new Companion(null);
        patterns = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_CREATE, (Object)new EndObjectKindPattern(SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIRTUAL_TABLE}), SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCommonTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION}), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonTokens.SQL_LEFT_PAREN, (Object)new EndIncElementPattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE))), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ENGINE_CLAUSE, (Object)new SingleElementPattern((Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE))), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE, (Object)new SingleElementPattern((Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_ON, (Object)new ElementTypeSetPattern(SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_COMMIT, SqlCommonKeywords.SQL_PRESERVE, SqlCommonKeywords.SQL_DELETE, SqlCommonKeywords.SQL_ROWS}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.5.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_TABLESPACE, (Object)new ElementTypeSetPattern(SetsKt.setOf((Object)SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.6.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_WITH, (Object)new EndIncElementPattern(SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_OIDS, SqlCommonTokens.SQL_RIGHT_PAREN}), SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_WITH, SqlCommonKeywords.SQL_TABLESPACE}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.7.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_WITHOUT, (Object)new ElementTypeSetPattern(SetsKt.setOf((Object)SqlCommonKeywords.SQL_OIDS), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.8.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_USING, (Object)new ElementTypeSetPattern(SetsKt.setOf((Object)SqlCompositeElementTypes.SQL_IDENTIFIER), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.9.INSTANCE)))});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$TableHeaderSection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "intellij.database.sql.impl"})
    public static final class TableHeaderSection
    extends SqlRangeBlock {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final Map<IElementType, FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

