from django.utils.translation import gettext_lazy as _

#: A list of Latvian municipalities and republican cities.
#: Identifiers based on ISO 3166-2:LV. https://en.wikipedia.org/wiki/ISO_3166-2:LV
MUNICIPALITY_CHOICES = (
    # Republican cities (not part of any municipality)
    ('DGV', _('Daugavpils')),
    ('JEL', _('Jelgava')),
    ('JKB', _('Jēkabpils')),
    ('JUR', _('Jūrmala')),
    ('LPX', _('Liepāja')),
    ('REZ', _('Rēzekne')),
    ('RIX', _('Riga')),
    ('VMR', _('Valmiera')),
    ('VEN', _('Ventspils')),
    # Municipalities
    ('001', _('Aglona municipality')),
    ('002', _('Aizkraukle municipality')),
    ('003', _('Aizpute municipality')),
    ('004', _('Aknīste municipality')),
    ('005', _('Aloja municipality')),
    ('006', _('Alsunga municipality')),
    ('007', _('Alūksne municipality')),
    ('008', _('Amata municipality')),
    ('009', _('Ape municipality')),
    ('010', _('Auce municipality')),
    ('011', _('Ādaži municipality')),
    ('012', _('Babīte municipality')),
    ('013', _('Baldone municipality')),
    ('014', _('Baltinava municipality')),
    ('015', _('Balvi municipality')),
    ('016', _('Bauska municipality')),
    ('017', _('Beverīna municipality')),
    ('018', _('Brocēni municipality')),
    ('019', _('Burtnieki municipality')),
    ('020', _('Carnikava municipality')),
    ('021', _('Cesvaine municipality')),
    ('022', _('Cēsis municipality')),
    ('023', _('Cibla municipality')),
    ('024', _('Dagda municipality')),
    ('025', _('Daugavpils municipality')),
    ('026', _('Dobele municipality')),
    ('027', _('Dundaga municipality')),
    ('028', _('Durbe municipality')),
    ('029', _('Engure municipality')),
    ('030', _('Ērgļi municipality')),
    ('031', _('Garkalne municipality')),
    ('032', _('Grobiņa municipality')),
    ('033', _('Gulbene municipality')),
    ('034', _('Iecava municipality')),
    ('035', _('Ikšķile municipality')),
    ('036', _('Ilūkste municipality')),
    ('037', _('Inčukalns municipality')),
    ('038', _('Jaunjelgava municipality')),
    ('039', _('Jaunpiebalga municipality')),
    ('040', _('Jaunpils municipality')),
    ('041', _('Jelgava municipality')),
    ('042', _('Jēkabpils municipality')),
    ('043', _('Kandava municipality')),
    ('044', _('Kārsava municipality')),
    ('045', _('Kocēni municipality')),
    ('046', _('Koknese municipality')),
    ('047', _('Krāslava municipality')),
    ('048', _('Krimulda municipality')),
    ('049', _('Krustpils municipality')),
    ('050', _('Kuldīga municipality')),
    ('051', _('Ķegums municipality')),
    ('052', _('Ķekava municipality')),
    ('053', _('Lielvārde municipality')),
    ('054', _('Limbaži municipality')),
    ('055', _('Līgatne municipality')),
    ('056', _('Līvāni municipality')),
    ('057', _('Lubāna municipality')),
    ('058', _('Ludza municipality')),
    ('059', _('Madona municipality')),
    ('060', _('Mazsalaca municipality')),
    ('061', _('Mālpils municipality')),
    ('062', _('Mārupe municipality')),
    ('063', _('Mērsrags municipality')),
    ('064', _('Naukšēni municipality')),
    ('065', _('Nereta municipality')),
    ('066', _('Nīca municipality')),
    ('067', _('Ogre municipality')),
    ('068', _('Olaine municipality')),
    ('069', _('Ozolnieki municipality')),
    ('070', _('Pārgauja municipality')),
    ('071', _('Pāvilosta municipality')),
    ('072', _('Pļaviņas municipality')),
    ('073', _('Preiļi municipality')),
    ('074', _('Priekule municipality')),
    ('075', _('Priekuļi municipality')),
    ('076', _('Rauna municipality')),
    ('077', _('Rēzekne municipality')),
    ('078', _('Riebiņi municipality')),
    ('079', _('Roja municipality')),
    ('080', _('Ropaži municipality')),
    ('081', _('Rucava municipality')),
    ('082', _('Rugāji municipality')),
    ('083', _('Rundāle municipality')),
    ('084', _('Rūjiena municipality')),
    ('085', _('Sala municipality')),
    ('086', _('Salacgrīva municipality')),
    ('087', _('Salaspils municipality')),
    ('088', _('Saldus municipality')),
    ('089', _('Saulkrasti municipality')),
    ('090', _('Sēja municipality')),
    ('091', _('Sigulda municipality')),
    ('092', _('Skrīveri municipality')),
    ('093', _('Skrunda municipality')),
    ('094', _('Smiltene municipality')),
    ('095', _('Stopiņi municipality')),
    ('096', _('Strenči municipality')),
    ('097', _('Talsi municipality')),
    ('098', _('Tērvete municipality')),
    ('099', _('Tukums municipality')),
    ('100', _('Vaiņode municipality')),
    ('101', _('Valka municipality')),
    ('102', _('Varakļāni municipality')),
    ('103', _('Vārkava municipality')),
    ('104', _('Vecpiebalga municipality')),
    ('105', _('Vecumnieki municipality')),
    ('106', _('Ventspils municipality')),
    ('107', _('Viesīte municipality')),
    ('108', _('Viļaka municipality')),
    ('109', _('Viļāni municipality')),
    ('110', _('Zilupe municipality')),
)
