##
# Borges::HtmlElement holds attributes and children elements for
# building HTML.

class Borges::HtmlElement
  
  ##
  # A list of id attributes

  @@ids = []

  ##
  # The name of the HTML element

  attr_accessor :name

  ##
  # Add a child element to this element

  def add(element)
    @children << element
  end

  ##
  # Create a new HTML element with +name+, an optional set of
  # +attributes+, and an empty set of children.

  def initialize(name, attributes = Borges::HtmlAttributes.new)
    @children = []
    @name = name
    @attributes = attributes
  end

  ##
  # Create a String representing this element

  def to_s
    str = "<#{@name}#{@attributes}>#{@children}"
    str << "</#{@name}>" unless @name.to_s =~ /hr|br|input|img|link|meta/
    str
  end

end

