/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.SubmoduleDeinitResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path : this.paths) {
                if (this.submoduleExists(path)) continue;
                throw new NoSuchSubmoduleException(path);
            }
            ArrayList<SubmoduleDeinitResult> results = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            try (RevWalk revWalk = new RevWalk(this.repo);
                 SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                StoredConfig config = this.repo.getConfig();
                while (generator.next()) {
                    String path = generator.getPath();
                    String name = generator.getModuleName();
                    SubmoduleDeinitStatus status = this.checkDirty(revWalk, path);
                    switch (status) {
                        case SUCCESS: {
                            this.deinit(path);
                            break;
                        }
                        case ALREADY_DEINITIALIZED: {
                            break;
                        }
                        case DIRTY: {
                            if (!this.force) break;
                            this.deinit(path);
                            status = SubmoduleDeinitStatus.FORCED;
                            break;
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status}));
                        }
                    }
                    config.unsetSection("submodule", name);
                    results.add(new SubmoduleDeinitResult(path, status));
                }
            }
            return results;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void deinit(String path) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            for (int i = 0; i < ls.length; ++i) {
                FileUtils.delete(ls[i], 1);
            }
        }
    }

    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path) throws GitAPIException, IOException {
        ObjectId submoduleHead;
        Ref head = this.repo.exactRef("HEAD");
        if (head == null) {
            throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
        }
        RevCommit headCommit = revWalk.parseCommit(head.getObjectId());
        RevTree tree = headCommit.getTree();
        try (SubmoduleWalk w = SubmoduleWalk.forPath(this.repo, tree, path);){
            submoduleHead = w.getHead();
            if (submoduleHead == null) {
                SubmoduleDeinitStatus submoduleDeinitStatus = SubmoduleDeinitStatus.ALREADY_DEINITIALIZED;
                return submoduleDeinitStatus;
            }
            if (!submoduleHead.equals(w.getObjectId())) {
                SubmoduleDeinitStatus submoduleDeinitStatus = SubmoduleDeinitStatus.DIRTY;
                return submoduleDeinitStatus;
            }
        }
        w = SubmoduleWalk.forIndex(this.repo);
        var8_7 = null;
        try {
            if (!w.next()) {
                SubmoduleDeinitStatus submoduleDeinitStatus = SubmoduleDeinitStatus.DIRTY;
                return submoduleDeinitStatus;
            }
            if (!submoduleHead.equals(w.getObjectId())) {
                SubmoduleDeinitStatus submoduleDeinitStatus = SubmoduleDeinitStatus.DIRTY;
                return submoduleDeinitStatus;
            }
            Repository submoduleRepo = w.getRepository();
            Status status = Git.wrap(submoduleRepo).status().call();
            SubmoduleDeinitStatus submoduleDeinitStatus = status.isClean() ? SubmoduleDeinitStatus.SUCCESS : SubmoduleDeinitStatus.DIRTY;
            return submoduleDeinitStatus;
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var8_7 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }

    private boolean submoduleExists(String path) throws IOException {
        PathFilter filter = PathFilter.create(path);
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            boolean bl = w.setFilter(filter).next();
            return bl;
        }
    }

    public SubmoduleDeinitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path));
        }
    }
}

