/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.rails3.checklist;

import b.h.la;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RIdentifierImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public class RailsChecklistHelper {
    public static final String FIND_METHOD_PREFIX = "find";
    private static final String a = "find_or_create";
    public static final String CONSTRUCTOR_PREFIX = "new";
    public static final Set<String> KERNEL_METHODS_TO_SKIP_CHECK;
    public static final String INIT_METHOD_NAME = "initialize";
    private static final long b;

    private RailsChecklistHelper() {
    }

    public static boolean isCallModelMethod(@NotNull RDotReference dotReference) {
        RPsiElement rPsiElement;
        if (dotReference == null) {
            RailsChecklistHelper.a(0);
        }
        if ((rPsiElement = dotReference.getReceiver()) == null) {
            return false;
        }
        PsiReference psiReference = rPsiElement.getReference();
        if (psiReference == null) {
            return false;
        }
        RType rType = null;
        PsiElement psiElement = psiReference.resolve();
        if (psiElement != null) {
            if (psiElement instanceof RInstanceVariable) {
                RInstanceVariable rInstanceVariable = (RInstanceVariable)psiElement;
                RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)rInstanceVariable);
                if (rAssignmentExpression != null) {
                    rType = rAssignmentExpression.getType();
                }
            } else if (psiElement instanceof RClass) {
                RClass rClass = (RClass)psiElement;
                rType = RTypeUtil.getTypeByClass(rClass);
            } else if (psiElement instanceof RIdentifierImpl) {
                RIdentifierImpl rIdentifierImpl = (RIdentifierImpl)psiElement;
                rType = rIdentifierImpl.getType();
            }
            if (rType instanceof ActiveRecordType) {
                return true;
            }
        }
        return false;
    }

    private static boolean c(@NotNull RDotReference rDotReference) {
        String string;
        if (rDotReference == null) {
            RailsChecklistHelper.a(1);
        }
        return (string = rDotReference.getCommand()) != null && RailsChecklistHelper.a(string);
    }

    private static boolean a(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            RailsChecklistHelper.a(2);
        }
        return RailsChecklistHelper.a(rMethod.getName());
    }

    private static boolean a(String string) {
        long l2 = b ^ 0x509A61D5CE63L;
        return string != null && string.startsWith(FIND_METHOD_PREFIX) && !string.startsWith(a);
    }

    private static boolean b(@NotNull RDotReference rDotReference) {
        String string;
        long l2 = b ^ 0x73382F0E58B2L;
        if (rDotReference == null) {
            RailsChecklistHelper.a(3);
        }
        return (string = rDotReference.getCommand()) != null && (string.equals(CONSTRUCTOR_PREFIX) || string.equals(INIT_METHOD_NAME));
    }

    private static boolean a(@NotNull RDotReference rDotReference) {
        if (rDotReference == null) {
            RailsChecklistHelper.a(4);
        }
        String string = rDotReference.getCommand();
        return KERNEL_METHODS_TO_SKIP_CHECK.contains(string);
    }

    public static boolean isModelFindMethod(@NotNull RDotReference dotReference) {
        if (dotReference == null) {
            RailsChecklistHelper.a(5);
        }
        return RailsChecklistHelper.isCallModelMethod(dotReference) && RailsChecklistHelper.c(dotReference);
    }

    public static boolean isModelFindMethod(@NotNull RMethod rMethod) {
        RContainer rContainer;
        if (rMethod == null) {
            RailsChecklistHelper.a(6);
        }
        if (RailsChecklistHelper.a(rMethod) && (rContainer = rMethod.getParentContainer()) instanceof RClass) {
            RClass rClass = (RClass)rContainer;
            RType rType = RTypeUtil.getTypeByClass(rClass);
            return rType instanceof ActiveRecordType;
        }
        return false;
    }

    public static boolean isRailsModelBusinessLogicCall(@NotNull RDotReference dotReference) {
        if (dotReference == null) {
            RailsChecklistHelper.a(7);
        }
        return RailsChecklistHelper.isCallModelMethod(dotReference) && !RailsChecklistHelper.c(dotReference) && !RailsChecklistHelper.b(dotReference) && !RailsChecklistHelper.a(dotReference);
    }

    public static boolean isViewElement(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RailsChecklistHelper.a(8);
        }
        PsiFile psiFile = rPsiElement.getContainingFile();
        RailsView railsView = RailsView.fromFile(psiFile);
        RailsPartialView railsPartialView = RailsPartialView.fromFile(psiFile);
        return railsView != null || railsPartialView != null;
    }

    public static boolean isHelperElement(@NotNull RPsiElement rPsiElement) {
        PsiFile psiFile;
        RailsHelper railsHelper;
        if (rPsiElement == null) {
            RailsChecklistHelper.a(9);
        }
        return (railsHelper = RailsHelper.fromFile(psiFile = rPsiElement.getContainingFile())) != null;
    }

    static {
        b = la.a(7131683804813087547L, -4213836890328427234L, MethodHandles.lookup().lookupClass()).a(51179098826584L);
        long l2 = b ^ 0x63113BE96DE5L;
        KERNEL_METHODS_TO_SKIP_CHECK = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("method_missing", "nil?")));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x5576B8878A14L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotReference";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/rails3/checklist/RailsChecklistHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallModelMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFindMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructorMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodMissingMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isModelFindMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRailsModelBusinessLogicCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isViewElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isHelperElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

