/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import b.h.la;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.debugger.RubyDebugConsoleBuilder;
import org.jetbrains.plugins.ruby.console.debugger.RubyDuplexDebugConsoleBuilder;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.MyRubyDebugEventListener;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEditorsProvider;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyExceptionBreakpointHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLineBreakpointHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;

public class RubyDebugProcess
extends XDebugProcess {
    private static final Logger e;
    @NotNull
    private final Collection<? extends VirtualFile> a;
    @NotNull
    private final Collection<? extends VirtualFile> l;
    private final boolean k;
    @NotNull
    private final ExecutionEnvironment i;
    private RubyStackFrame b;
    final XBreakpointHandler<?>[] myBreakPointHandlers;
    RubyDebuggerProxy[] myRubyDebuggerProxies;
    final Set<RubyDebuggerProxy> myStoppedProxies;
    final RubyDebugEventListener myRubyDebugEventListener;
    final RunProfileState myState;
    final RubyLineBreakpointHandler myLineBreakpointHandler;
    final RubyExceptionBreakpointHandler myExceptionBreakpointHandler;
    private final ProcessHandler d;
    private final int c;
    private final SourcePositionConverter h;
    @Nullable
    private final RubyProcessDispatcher g;
    @Nullable
    private final XDebugTabLayouter j;
    private volatile boolean f;
    private static final long n;

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        RubyDebuggerEditorsProvider rubyDebuggerEditorsProvider = new RubyDebuggerEditorsProvider();
        if (rubyDebuggerEditorsProvider == null) {
            RubyDebugProcess.a(0);
        }
        return rubyDebuggerEditorsProvider;
    }

    public RubyDebugProcess(final @NotNull XDebugSession session, @NotNull RunProfileState state, @Nullable ProcessHandler processHandler, @NotNull RubyDebuggerProxy rubyDebuggerProxy, int rubyDebugTimeout, SourcePositionConverter positionConverter, @NotNull ExecutionEnvironment executionEnvironment, @Nullable RubyProcessDispatcher acceptor, boolean pauseActionSupported, boolean debugConsoleSupported, boolean enableFileFiltering, @NotNull Collection<? extends VirtualFile> dirsToInclude, @NotNull Collection<? extends VirtualFile> dirsToExclude) {
        if (session == null) {
            RubyDebugProcess.a(1);
        }
        if (state == null) {
            RubyDebugProcess.a(2);
        }
        if (rubyDebuggerProxy == null) {
            RubyDebugProcess.a(3);
        }
        if (executionEnvironment == null) {
            RubyDebugProcess.a(4);
        }
        if (dirsToInclude == null) {
            RubyDebugProcess.a(5);
        }
        if (dirsToExclude == null) {
            RubyDebugProcess.a(6);
        }
        super(session);
        this.myRubyDebuggerProxies = new RubyDebuggerProxy[0];
        this.myStoppedProxies = new HashSet<RubyDebuggerProxy>();
        this.f = false;
        this.i = executionEnvironment;
        session.setPauseActionSupported(pauseActionSupported);
        this.myState = state;
        this.d = processHandler;
        this.k = enableFileFiltering;
        this.a = dirsToInclude;
        this.l = dirsToExclude;
        this.g = acceptor;
        if (this.g != null) {
            this.g.setProcess(this);
            this.g.setProcessHandler(this.d);
        }
        if (this.d != null) {
            this.d.addProcessListener((ProcessListener)new DebugSessionController());
        }
        this.c = rubyDebugTimeout;
        this.h = positionConverter;
        this.myRubyDebugEventListener = new MyRubyDebugEventListener(session.getProject(), this);
        this.myLineBreakpointHandler = new RubyLineBreakpointHandler(this);
        this.myExceptionBreakpointHandler = new RubyExceptionBreakpointHandler(this);
        this.myBreakPointHandlers = new XBreakpointHandler[]{this.myLineBreakpointHandler, this.myExceptionBreakpointHandler};
        this.registerDebuggerProxy(rubyDebuggerProxy);
        session.addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                if (session.getCurrentStackFrame() instanceof RubyStackFrame) {
                    RubyDebugProcess.this.b = (RubyStackFrame)session.getCurrentStackFrame();
                } else {
                    RubyDebugProcess.this.b = null;
                }
            }
        });
        if (debugConsoleSupported && state instanceof RAbstractTestsCommandLineState) {
            this.j = new MyDebugTabLayouterWithDebuggerConsole(((RAbstractTestsCommandLineState)state).createConsoleMessageFilters());
        } else {
            if (debugConsoleSupported && state instanceof CommandLineState) {
                RubyDuplexDebugConsoleBuilder rubyDuplexDebugConsoleBuilder = new RubyDuplexDebugConsoleBuilder(this.getSession().getProject(), this);
                ((CommandLineState)state).setConsoleBuilder((TextConsoleBuilder)rubyDuplexDebugConsoleBuilder);
            }
            this.j = null;
        }
    }

    public void registerDebuggerProxy(RubyDebuggerProxy rubyDebuggerProxy) {
        this.myRubyDebuggerProxies = (RubyDebuggerProxy[])ArrayUtil.append((Object[])this.myRubyDebuggerProxies, (Object)rubyDebuggerProxy);
        rubyDebuggerProxy.addRubyDebugEventListener(this.myRubyDebugEventListener);
    }

    public void sessionInitialized() {
        super.sessionInitialized();
        if (this.d == null) {
            this.a();
        }
    }

    public boolean checkCanPerformCommands() {
        return this.f;
    }

    private void a() {
        long l2 = n ^ 0x53B41F746B43L;
        ProgressManager.getInstance().run((Task)new Task.Modal(null, RBundle.message((String)"ruby.debugger.connecting"), true){
            private static final long a = la.a(7738957761281612467L, -8709487249688689903L, MethodHandles.lookup().lookupClass()).a(3969804656618L);

            public void run(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x63FC5EC60DDAL;
                if (indicator == null) {
                    2.a(0);
                }
                indicator.setText(RBundle.message((String)"ruby.debugger.cannot.connect.timeout", (Object[])new Object[]{RubyDebugProcess.this.c}));
                indicator.setIndeterminate(false);
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
                Thread thread = RubyDebugProcess.this.a(indicator, atomicBoolean, atomicBoolean2);
                long l3 = System.currentTimeMillis();
                long l4 = (long)RubyDebugProcess.this.c * 1000L;
                while (!(indicator.isCanceled() || atomicBoolean.get() || atomicBoolean2.get())) {
                    long l5 = System.currentTimeMillis() - l3;
                    indicator.setFraction(Math.min(1.0, 1.0 * (double)l5 / (double)l4));
                    atomicBoolean.set(l5 > l4);
                    TimeoutUtil.sleep((long)50L);
                }
                if (!atomicBoolean2.get() && (indicator.isCanceled() || atomicBoolean.get())) {
                    e.warn("Unable to connect debugger in specified timeout");
                    thread.interrupt();
                    RubyDebugProcess.this.getProcessHandler().destroyProcess();
                    indicator.checkCanceled();
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4471A664942L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$2", "run"));
            }
        });
        this.f = true;
    }

    @NotNull
    private Thread a(@NotNull ProgressIndicator progressIndicator, @NotNull AtomicBoolean atomicBoolean, @NotNull AtomicBoolean atomicBoolean2) {
        long l2 = n ^ 0x5818C60C083BL;
        if (progressIndicator == null) {
            RubyDebugProcess.a(7);
        }
        if (atomicBoolean == null) {
            RubyDebugProcess.a(8);
        }
        if (atomicBoolean2 == null) {
            RubyDebugProcess.a(9);
        }
        Thread thread = new Thread(() -> {
            block7: {
                long l2 = n ^ 0x7827AEBA5116L;
                if (atomicBoolean2 == null) {
                    RubyDebugProcess.a(18);
                }
                if (progressIndicator == null) {
                    RubyDebugProcess.a(19);
                }
                if (atomicBoolean == null) {
                    RubyDebugProcess.a(20);
                }
                try {
                    if (e.isDebugEnabled()) {
                        e.debug("Connecting to debugger");
                    }
                    this.attachToProxy(this.myRubyDebuggerProxies[0]);
                    atomicBoolean2.set(true);
                    if (e.isDebugEnabled()) {
                        e.debug("Connected successfully");
                    }
                }
                catch (RubyDebuggerException rubyDebuggerException) {
                    e.info("Couldn't connect to debugger: ", (Throwable)rubyDebuggerException);
                    this.getProcessHandler().destroyProcess();
                    if (progressIndicator.isCanceled()) break block7;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        long l2 = n ^ 0x1D2108F1B9F0L;
                        if (atomicBoolean == null) {
                            RubyDebugProcess.a(21);
                        }
                        String string = rubyDebuggerException.getMessage();
                        if (atomicBoolean.get()) {
                            string = string + "\nPlease try increasing timeout in Settings | Debugger | Ruby | Debug connection timeout";
                        }
                        Messages.showErrorDialog((String)string, (String)RBundle.message((String)"ruby.debugger.cannot.connect"));
                    });
                }
            }
        }, "ruby attach process");
        thread.start();
        Thread thread2 = thread;
        if (thread2 == null) {
            RubyDebugProcess.a(10);
        }
        return thread2;
    }

    public void attachToProxy(RubyDebuggerProxy proxy) throws RubyDebuggerException {
        ArrayList<IRubyBreakpoint> arrayList = new ArrayList<IRubyBreakpoint>();
        arrayList.addAll(this.myLineBreakpointHandler.mySource2BreakpointMap.values());
        arrayList.addAll(this.myExceptionBreakpointHandler.myName2BreakpointMap.values());
        Function function = virtualFile -> this.getPositionConverter().getRemotePath((VirtualFile)virtualFile);
        proxy.attach(this.k, arrayList.toArray(new IRubyBreakpoint[0]), Collections2.transform(this.a, (Function)function), Collections2.transform(this.l, (Function)function));
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.d;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        if (this.j == null) {
            XDebugTabLayouter xDebugTabLayouter = super.createTabLayouter();
            if (xDebugTabLayouter == null) {
                RubyDebugProcess.a(11);
            }
            return xDebugTabLayouter;
        }
        XDebugTabLayouter xDebugTabLayouter = this.j;
        if (xDebugTabLayouter == null) {
            RubyDebugProcess.a(12);
        }
        return xDebugTabLayouter;
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        long l2 = n ^ 0x386CF4D23D07L;
        try {
            RubyThread rubyThread = this.b();
            if (rubyThread == null) {
                e.warn("Can not step into (thread is null)");
                return;
            }
            RubyFrame[] rubyFrameArray = rubyThread.getFrames();
            if (rubyThread.getProxy().waitForDebuggerProxyReady()) {
                rubyThread.getProxy().sendStepIntoEnd(rubyFrameArray[0], false);
                this.markProxyActive(rubyThread.getProxy());
                if (e.isDebugEnabled()) {
                    e.debug("Step into");
                }
            } else {
                e.warn("Couldn't step into during timeout");
            }
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            e.info((Throwable)rubyDebuggerException);
        }
    }

    @Nullable
    private RubyThread b() {
        return this.b != null ? this.b.getRubyThread() : null;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        long l2 = n ^ 0x39A0C609BF4CL;
        try {
            RubyThread rubyThread = this.b();
            if (rubyThread == null) {
                e.warn("Can not start step over because thread is null");
                return;
            }
            RubyFrame[] rubyFrameArray = rubyThread.getFrames();
            rubyThread.getProxy().sendStepOver(rubyFrameArray[0], false);
            this.markProxyActive(rubyThread.getProxy());
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            e.info((Throwable)rubyDebuggerException);
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        long l2 = n ^ 0x2BA65EC73179L;
        try {
            RubyThread rubyThread = this.b();
            if (rubyThread == null) {
                e.warn("Can not step out (thread is null)");
                return;
            }
            rubyThread.getProxy().sendStepReturnEnd(rubyThread.getFrames()[0]);
            this.markProxyActive(rubyThread.getProxy());
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            e.info((Throwable)rubyDebuggerException);
        }
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        RubyThread rubyThread;
        long l2 = n ^ 0x5B1526ED99DBL;
        if (position == null) {
            RubyDebugProcess.a(13);
        }
        if ((rubyThread = this.b()) == null) {
            e.warn("Can not run to position (thread is null)");
            return;
        }
        if (rubyThread.getProxy().waitForDebuggerProxyReady()) {
            RubyPosition rubyPosition = this.getPositionConverter().createRemotePosition(position);
            try {
                String string = rubyPosition.getPath();
                int n2 = rubyPosition.getLine();
                this.markProxyActive(rubyThread.getProxy());
                rubyThread.runTo(string, n2);
                if (e.isDebugEnabled()) {
                    e.debug("Run to position: " + string + ":" + n2);
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                e.info((Throwable)rubyDebuggerException);
            }
        } else {
            e.warn("Couldn't run to position during timeout");
        }
    }

    public void stop() {
        long l2 = n ^ 0x7FB5844A1B85L;
        for (RubyDebuggerProxy rubyDebuggerProxy : this.myRubyDebuggerProxies) {
            if (rubyDebuggerProxy.waitForDebuggerProxyReady()) {
                rubyDebuggerProxy.removeRubyDebugEventListener(this.myRubyDebugEventListener);
                this.getSession().resume();
                if (e.isDebugEnabled()) {
                    e.debug("Stopping debug server");
                }
                rubyDebuggerProxy.finish(true);
                this.markProxyActive(rubyDebuggerProxy);
                if (!e.isDebugEnabled()) continue;
                e.debug("Debugger session finished");
                continue;
            }
            e.warn("Couldn't stop during timeout");
        }
        if (this.g != null) {
            this.g.stop();
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        for (RubyDebuggerProxy rubyDebuggerProxy : this.myRubyDebuggerProxies) {
            RubyThread rubyThread = RubyDebugProcess.a(rubyDebuggerProxy);
            if (rubyThread == null) continue;
            rubyDebuggerProxy.resume(rubyThread);
            this.markProxyActive(rubyDebuggerProxy);
        }
    }

    @Nullable
    private static RubyThread a(RubyDebuggerProxy rubyDebuggerProxy) {
        for (RubyThread rubyThread : rubyDebuggerProxy.getDebugTarget().getThreads()) {
            if (!rubyThread.isSuspended()) continue;
            return rubyThread;
        }
        return null;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakPointHandlers == null) {
            RubyDebugProcess.a(14);
        }
        return this.myBreakPointHandlers;
    }

    public SourcePositionConverter getPositionConverter() {
        return this.h;
    }

    public void removeBreakPoint(IRubyBreakpoint breakpoint) {
        long l2 = n ^ 0x353952EFF0A3L;
        if (!this.f) {
            e.warn("Attempt to remove breakpoint when session is not initialized yet");
        }
        for (RubyDebuggerProxy rubyDebuggerProxy : this.myRubyDebuggerProxies) {
            rubyDebuggerProxy.removeBreakpoint(breakpoint);
        }
    }

    public void addBreakPoint(IRubyBreakpoint breakpoint) {
        if (this.f) {
            for (RubyDebuggerProxy rubyDebuggerProxy : this.myRubyDebuggerProxies) {
                rubyDebuggerProxy.addBreakpoint(breakpoint);
            }
        }
    }

    public void startPausing() {
        long l2 = n ^ 0x3BD738775BA9L;
        for (RubyDebuggerProxy rubyDebuggerProxy : this.myRubyDebuggerProxies) {
            if (rubyDebuggerProxy.waitForDebuggerProxyReady()) {
                rubyDebuggerProxy.threadPause(1);
                continue;
            }
            e.warn("Couldn't pause proxy: " + rubyDebuggerProxy);
        }
    }

    public boolean isProxyStopped(RubyDebuggerProxy origin) {
        return this.myStoppedProxies.contains(origin);
    }

    public void markProxyPaused(RubyDebuggerProxy origin) {
        this.myStoppedProxies.add(origin);
    }

    public void markProxyActive(RubyDebuggerProxy origin) {
        this.myStoppedProxies.remove(origin);
    }

    public void terminateEventSeen(RubyDebuggerProxy origin) {
        this.markProxyActive(origin);
        this.myRubyDebuggerProxies = (RubyDebuggerProxy[])ArrayUtil.remove((Object[])this.myRubyDebuggerProxies, (Object)origin);
        origin.removeRubyDebugEventListener(this.myRubyDebugEventListener);
    }

    @NotNull
    public ExecutionConsole createConsole() {
        DefaultExecutionResult defaultExecutionResult;
        if (!(this.myState instanceof RubyAbstractCommandLineState) || this.d == null) {
            ExecutionConsole executionConsole = super.createConsole();
            if (executionConsole == null) {
                RubyDebugProcess.a(15);
            }
            return executionConsole;
        }
        try {
            defaultExecutionResult = ((RubyAbstractCommandLineState)this.myState).execute(this.i.getExecutor(), this.i.getRunner(), this.d);
        }
        catch (ExecutionException executionException) {
            ExecutionConsole executionConsole = super.createConsole();
            if (executionConsole == null) {
                RubyDebugProcess.a(16);
            }
            return executionConsole;
        }
        XDebugSession xDebugSession = this.getSession();
        if (xDebugSession instanceof XDebugSessionImpl) {
            ((XDebugSessionImpl)xDebugSession).addRestartActions(defaultExecutionResult.getRestartActions());
        }
        ExecutionConsole executionConsole = defaultExecutionResult.getExecutionConsole();
        if (executionConsole == null) {
            RubyDebugProcess.a(17);
        }
        return executionConsole;
    }

    static {
        n = la.a(-8854413193333119682L, 6667675112262638794L, MethodHandles.lookup().lookupClass()).a(98982891329459L);
        e = Logger.getInstance(RubyDebugProcess.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x1EEE4798878AL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyDebuggerProxy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToInclude";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToExclude";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attached";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttachingThread";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startAttachingThread";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startAttachingThread$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDebugTabLayouterWithDebuggerConsole
    extends XDebugTabLayouter {
        @NotNull
        private final List<Filter> a;
        private static final long b = la.a(-1129101990413160367L, 8461511015033945335L, MethodHandles.lookup().lookupClass()).a(178859128944453L);

        MyDebugTabLayouterWithDebuggerConsole(List<Filter> consoleMessageFilters) {
            if (consoleMessageFilters == null) {
                MyDebugTabLayouterWithDebuggerConsole.a(0);
            }
            this.a = consoleMessageFilters;
        }

        public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
            long l2 = b ^ 0x3F6CC1646338L;
            if (ui == null) {
                MyDebugTabLayouterWithDebuggerConsole.a(1);
            }
            ConsoleView consoleView = new RubyDebugConsoleBuilder(RubyDebugProcess.this.getSession().getProject(), RubyDebugProcess.this).filters(this.a).getConsole();
            Content content = ui.createContent("Debugger console view", consoleView.getComponent(), RBundle.message((String)"debugger.console.layout.tab.name"), AllIcons.Debugger.Console, consoleView.getPreferredFocusableComponent());
            content.setCloseable(false);
            content.setActions((ActionGroup)new DefaultActionGroup(consoleView.createConsoleActions()), "DebuggerToolbar", consoleView.getPreferredFocusableComponent());
            ui.addContent(content, 3, PlaceInGrid.right, false);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x1DC189E2EB62L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleMessageFilters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$MyDebugTabLayouterWithDebuggerConsole";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAdditionalContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class DebugSessionController
    extends ProcessAdapter {
        private boolean a = false;
        private static final long b = la.a(5895571264294444384L, -6533660305789245143L, MethodHandles.lookup().lookupClass()).a(205105841525711L);

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            long l2 = b ^ 0x5C23E006C185L;
            if (event == null) {
                DebugSessionController.a(0);
            }
            if (outputType == null) {
                DebugSessionController.a(1);
            }
            String string = event.getText();
            if (!RubyDebugProcess.this.f && string != null && !ProcessOutputTypes.SYSTEM.equals((Object)outputType) && string.contains("Fast Debugger ")) {
                ApplicationManager.getApplication().invokeLater(() -> RubyDebugProcess.this.a());
            }
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            if (event == null) {
                DebugSessionController.a(2);
            }
            if (RubyDebugProcess.this.getSession().isSuspended()) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (!RubyDebugProcess.this.getSession().areBreakpointsMuted()) {
                        RubyDebugProcess.this.getSession().setBreakpointMuted(true);
                        this.a = true;
                    }
                });
                RubyDebugProcess.this.getSession().resume();
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                DebugSessionController.a(3);
            }
            if (this.a) {
                ApplicationManager.getApplication().runReadAction(() -> RubyDebugProcess.this.getSession().setBreakpointMuted(false));
            }
            super.processTerminated(event);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x6096646AA9DL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$DebugSessionController";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processWillTerminate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

