/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import b.h.la;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopFileResultDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public class RubocopExternalAnnotator
extends ExternalAnnotator<RubocopInitialInformation, RubocopFileResultDescriptor> {
    public static final RubocopExternalAnnotator INSTANCE;
    public static final String FEATURE_RUBOCOP_AUTO_CHECK = "ruby.rubocop.check.background";
    public static final String FEATURE_RUBOCOP_MANUAL_CHECK = "ruby.rubocop.check.manual";
    static final String GEM_NAME = "rubocop";
    static final String GEM_SCRIPT_NAME = "rubocop";
    private static final Logger b;
    private static final String a = "Rubocop.Notification";
    private static final long c;

    @Nullable
    public RubocopInitialInformation collectInformation(@NotNull PsiFile psiFile) {
        long l2 = c ^ 0x1AA6D2B46412L;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = psiFile.getProject();
        if (project.isDisposed()) {
            b.debug("Project is disposed");
            return null;
        }
        if (!RubocopInspection.isEnabled(project)) {
            return null;
        }
        RubocopInitialInformation rubocopInitialInformation = RubocopExternalAnnotator.calcInitialInformation(psiFile);
        if (rubocopInitialInformation == null) {
            return null;
        }
        if (rubocopInitialInformation.getGemExecutionContext() != null) {
            return rubocopInitialInformation;
        }
        RubocopExternalAnnotator.handleMissingGem(rubocopInitialInformation);
        return null;
    }

    @Nullable
    public RubocopFileResultDescriptor doAnnotate(final RubocopInitialInformation initialInformation) {
        if (!initialInformation.isValid()) {
            return null;
        }
        RubyGemExecutionContext rubyGemExecutionContext = initialInformation.getGemExecutionContext();
        if (rubyGemExecutionContext == null) {
            return null;
        }
        RubocopResponse rubocopResponse = RubocopResponse.computeWithArguments(rubyGemExecutionContext, (ProcessListener)new ProcessAdapter(){
            private static final long a = la.a(-6804463985413800918L, -3691936712600080245L, MethodHandles.lookup().lookupClass()).a(153175422178726L);

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(0);
                }
                try (OutputStream outputStream = event.getProcessHandler().getProcessInput();){
                    if (outputStream == null) {
                        return;
                    }
                    outputStream.write(initialInformation.getSourceFileBytes());
                }
                catch (IOException iOException) {
                    b.warn((Throwable)iOException);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x64B872D770F0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator$1", "startNotified"));
            }
        });
        if (!rubocopResponse.isSuccess()) {
            String string = rubocopResponse.getErrorMessage();
            assert (string != null);
            RubocopExternalAnnotator.showRubocopError(string, RubocopExternalAnnotator.createDisableRubocopAction(initialInformation.getProject()));
            return null;
        }
        List<RubocopResponse.File> list2 = rubocopResponse.getFiles();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return initialInformation.isValid() ? new RubocopFileResultDescriptor(list2.get(0), rubyGemExecutionContext) : null;
    }

    @NotNull
    static AnAction createDisableRubocopAction(final @NotNull Project project) {
        long l2 = c ^ 0x51CD51B409L;
        if (project == null) {
            RubocopExternalAnnotator.a(1);
        }
        AnAction anAction = new AnAction(RBundle.message((String)"inspection.rubocop.disable")){
            private static final long a = la.a(7313614393376307274L, -3616770745324077621L, MethodHandles.lookup().lookupClass()).a(92747835546006L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                Notification.get((AnActionEvent)e10).expire();
                RubocopInspection.disableInspection(project, false);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7DADA376ACF5L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator$2", "actionPerformed"));
            }
        };
        if (anAction == null) {
            RubocopExternalAnnotator.a(2);
        }
        return anAction;
    }

    public void apply(@NotNull PsiFile psiFile, @NotNull RubocopFileResultDescriptor resultDescriptor, @NotNull AnnotationHolder holder) {
        long l2 = c ^ 0x4BE8249C899FL;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(3);
        }
        if (resultDescriptor == null) {
            RubocopExternalAnnotator.a(4);
        }
        if (holder == null) {
            RubocopExternalAnnotator.a(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        resultDescriptor.annotateOffenses(psiFile, holder);
        FeatureUsageTracker.getInstance().triggerFeatureUsed(FEATURE_RUBOCOP_AUTO_CHECK);
    }

    static boolean isSdkRubocopCompatible(@NotNull Sdk sdk) {
        long l2 = c ^ 0x4E502DFE7CB2L;
        if (sdk == null) {
            RubocopExternalAnnotator.a(6);
        }
        return RubyVersionUtil.isVersionGreaterOrEqual(sdk, "2.0");
    }

    static void handleMissingGem(@NotNull RubocopInitialInformation initialInformation) {
        if (initialInformation == null) {
            RubocopExternalAnnotator.a(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (initialInformation == null) {
                RubocopExternalAnnotator.a(20);
            }
            RubocopExternalAnnotator.a(initialInformation);
        });
    }

    private static void a(final @NotNull RubocopInitialInformation rubocopInitialInformation) {
        long l2 = c ^ 0x5AC0A76A7445L;
        if (rubocopInitialInformation == null) {
            RubocopExternalAnnotator.a(8);
        }
        b.debug("Rubocop gem is missing");
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Project project = rubocopInitialInformation.getProject();
        if (project.isDisposed()) {
            return;
        }
        if (!RubocopInspection.isEnabled(project)) {
            return;
        }
        RubocopInspection.disableInspection(project, true);
        final Sdk sdk = rubocopInitialInformation.getSdk();
        String string = RBundle.message((String)"inspection.rubocop.no.gem");
        NotificationListener.Adapter adapter = null;
        if (RubocopExternalAnnotator.isSdkRubocopCompatible(rubocopInitialInformation.getSdk())) {
            string = string + RBundle.message((String)"inspection.rubocop.no.gem.auto.link");
            adapter = new NotificationListener.Adapter(){
                private static final long a = la.a(-7187904391819754304L, 4696478340691063613L, MethodHandles.lookup().lookupClass()).a(142696554144444L);

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        3.a(0);
                    }
                    if (event == null) {
                        3.a(1);
                    }
                    notification.expire();
                    ApplicationManager.getApplication().assertReadAccessAllowed();
                    if (project.isDisposed()) {
                        return;
                    }
                    RubocopExternalAnnotator.installRubocopToSdk(rubocopInitialInformation.getModule(), sdk, () -> RubocopInspection.enableInspection(project));
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x17D32C9B9CC4L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator$3";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        } else {
            string = string + RBundle.message((String)"inspection.rubocop.no.gem.manual.text");
        }
        RubocopExternalAnnotator.showRubocopError(RBundle.message((String)"inspection.rubocop.disabled"), string, (NotificationListener)adapter, new AnAction[0]);
    }

    static void installRubocopToSdk(@Nullable Module module, @NotNull Sdk sdk, @Nullable Runnable callback) {
        long l2 = c ^ 0x38AACCCFFA7FL;
        if (sdk == null) {
            RubocopExternalAnnotator.a(9);
        }
        GemDependency gemDependency = GemDependency.create("rubocop", new String[0]);
        GemInstallUtil.installAndAddGemsInBackground(sdk, module, Collections.singletonList(gemDependency), true, false, callback, new HashMap<GemDependency, String>());
    }

    static void showRubocopError(@NotNull String message, AnAction ... actions) {
        if (message == null) {
            RubocopExternalAnnotator.a(10);
        }
        if (actions == null) {
            RubocopExternalAnnotator.a(11);
        }
        RubocopExternalAnnotator.showRubocopError(message, null, actions);
    }

    static void showRubocopError(@NotNull String message, @Nullable NotificationListener urlListener, AnAction ... actions) {
        long l2 = c ^ 0xBBCF7F24B26L;
        if (message == null) {
            RubocopExternalAnnotator.a(12);
        }
        if (actions == null) {
            RubocopExternalAnnotator.a(13);
        }
        RubocopExternalAnnotator.showRubocopError(RBundle.message((String)"inspection.rubocop.error"), message, urlListener, actions);
    }

    static void showRubocopError(@NotNull String title, @NotNull String message, @Nullable NotificationListener urlListener, AnAction ... actions) {
        long l2 = c ^ 0x8F82EC92986L;
        if (title == null) {
            RubocopExternalAnnotator.a(14);
        }
        if (message == null) {
            RubocopExternalAnnotator.a(15);
        }
        if (actions == null) {
            RubocopExternalAnnotator.a(16);
        }
        Notification notification = new Notification(a, title, message, NotificationType.ERROR, urlListener);
        for (AnAction anAction : actions) {
            notification.addAction(anAction);
        }
        Notifications.Bus.notify((Notification)notification);
    }

    @Nullable
    static RubocopInitialInformation calcInitialInformation(@NotNull PsiFile psiFile) {
        long l2 = c ^ 0x420194A51878L;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(17);
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (b.isDebugEnabled()) {
            b.debug("Computing info for: " + PsiUtilCore.getVirtualFile((PsiElement)psiFile));
        }
        if (!psiFile.getLanguage().is((Language)RubyLanguage.INSTANCE) || !virtualFile.isValid() || psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            if (b.isDebugEnabled()) {
                b.debug("Not good file: language: " + psiFile.getLanguage() + "; valid: " + virtualFile.isValid() + "; view provider: " + psiFile.getViewProvider());
            }
            return null;
        }
        Sdk sdk = RubocopExternalAnnotator.getFileSdk(project, virtualFile);
        if (b.isDebugEnabled()) {
            b.debug("File sdk is " + sdk);
        }
        return sdk == null ? null : new RubocopInitialInformation(sdk, psiFile);
    }

    @Nullable
    static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            RubocopExternalAnnotator.a(18);
        }
        if (virtualFile == null) {
            RubocopExternalAnnotator.a(19);
        }
        return virtualFile.isInLocalFileSystem() ? RModuleUtil.getInstance().findRubySdkForVirtualFile(project, virtualFile) : null;
    }

    static {
        c = la.a(8578537065992309512L, 1323238357674886199L, MethodHandles.lookup().lookupClass()).a(200922769551935L);
        INSTANCE = new RubocopExternalAnnotator();
        b = Logger.getInstance(RubocopExternalAnnotator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x48692C6364A9L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialInformation";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisableRubocopAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDisableRubocopAction";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSdkRubocopCompatible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleMissingGem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doHandleMissingGem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installRubocopToSdk";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showRubocopError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialInformation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleMissingGem$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

