/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBFactoryException;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFederatedProvider;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateRdbmsProvider;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateRdbmsProvider;
import org.jetbrains.dekaf.util.Providers;

public final class JdbcIntermediateFederatedProvider
implements IntegralIntermediateFederatedProvider {
    private final List<SpecificProvider> myRegisteredProviders = new CopyOnWriteArrayList<SpecificProvider>();
    private final ConcurrentMap<Rdbms, SpecificProvider> myBestProviders = new ConcurrentHashMap<Rdbms, SpecificProvider>();

    public JdbcIntermediateFederatedProvider() {
        Collection<IntegralIntermediateRdbmsProvider> rdbmsProviders = Providers.loadAllProviders(IntegralIntermediateRdbmsProvider.class, null);
        for (IntegralIntermediateRdbmsProvider rdbmsProvider : rdbmsProviders) {
            this.registerProvider(rdbmsProvider);
        }
    }

    public void registerProvider(@NotNull IntegralIntermediateRdbmsProvider provider) {
        Rdbms rdbms = provider.rdbms();
        byte specificity = provider.specificity();
        SpecificProvider sp = new SpecificProvider(rdbms, specificity, provider);
        this.myRegisteredProviders.add(sp);
        this.selectBestProvider(rdbms);
    }

    private void selectBestProvider(@NotNull Rdbms rdbms) {
        SpecificProvider theBest = null;
        for (SpecificProvider sp : this.myRegisteredProviders) {
            if (!sp.rdbms.equals(rdbms)) continue;
            if (theBest == null) {
                theBest = sp;
                continue;
            }
            if (sp.specificity >= theBest.specificity) continue;
            theBest = sp;
        }
        if (theBest != null) {
            this.myBestProviders.put(rdbms, theBest);
        } else {
            this.myBestProviders.remove(rdbms);
        }
    }

    public void deregisterProvider(@NotNull PrimeIntermediateRdbmsProvider provider) {
        Rdbms rdbms = provider.rdbms();
        for (int i = this.myRegisteredProviders.size() - 1; i >= 0; --i) {
            SpecificProvider sp = this.myRegisteredProviders.get(i);
            if (sp.provider != provider) continue;
            this.myRegisteredProviders.remove(i);
        }
        this.selectBestProvider(rdbms);
    }

    @Override
    @NotNull
    public Set<Rdbms> supportedRdbms() {
        return Collections.unmodifiableSet(this.myBestProviders.keySet());
    }

    @Override
    @NotNull
    public IntegralIntermediateFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit) {
        IntegralIntermediateRdbmsProvider provider = this.findTheBestFor(connectionString);
        return provider.openFacade(connectionString, connectionProperties, connectionsLimit);
    }

    private IntegralIntermediateRdbmsProvider findTheBestFor(String connectionString) {
        SpecificProvider theBest = null;
        for (SpecificProvider sp : this.myBestProviders.values()) {
            if (!JdbcIntermediateFederatedProvider.matches(connectionString, sp.provider.connectionStringPattern()) || theBest != null && sp.specificity >= theBest.specificity) continue;
            theBest = sp;
        }
        if (theBest != null) {
            return theBest.provider;
        }
        throw new DBFactoryException(String.format("No providers registered for connection string \"%s\"", connectionString));
    }

    @Override
    @Nullable
    public IntegralIntermediateRdbmsProvider getSpecificServiceProvider(@NotNull Rdbms rdbms) {
        SpecificProvider sp = (SpecificProvider)this.myBestProviders.get(rdbms);
        return sp != null ? sp.provider : null;
    }

    private static boolean matches(@NotNull String string, @NotNull Pattern pattern) {
        return pattern.matcher(string).matches();
    }

    private static final class SpecificProvider {
        @NotNull
        final Rdbms rdbms;
        final byte specificity;
        @NotNull
        final IntegralIntermediateRdbmsProvider provider;

        private SpecificProvider(@NotNull Rdbms rdbms, byte specificity, @NotNull IntegralIntermediateRdbmsProvider provider) {
            this.rdbms = rdbms;
            this.specificity = specificity;
            this.provider = provider;
        }

        public String toString() {
            return this.rdbms + "/" + this.specificity + " -> " + this.provider.getClass().getName();
        }
    }
}

