/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.PostgresDialectHelper;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;

    protected PostgresDialect() {
        super(new TypeHelper.PostgresTypeHelper(), Casing.create((Case)Case.LOWER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.POSTGRES;
        if (dbms == null) {
            PostgresDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Postgresql;
        if (icon == null) {
            PostgresDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("PostgreSQL" == null) {
            PostgresDialect.$$$reportNull$$$0(2);
        }
        return "PostgreSQL";
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            PostgresDialect.$$$reportNull$$$0(3);
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            PostgresDialect.$$$reportNull$$$0(4);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(5);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                PostgresDialect.$$$reportNull$$$0(6);
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                PostgresDialect.$$$reportNull$$$0(7);
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(11);
        }
        if (procedure == null) {
            PostgresDialect.$$$reportNull$$$0(12);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            DasArgument.Direction direction = arg.getArgumentDirection();
            if (direction != DasArgument.Direction.IN && direction != DasArgument.Direction.INOUT) continue;
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(14);
        }
        if (view == null) {
            PostgresDialect.$$$reportNull$$$0(15);
        }
        if (definition == null) {
            PostgresDialect.$$$reportNull$$$0(16);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view).space().keyword("AS").space().plain(definition);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(17);
        }
        if (view == null) {
            PostgresDialect.$$$reportNull$$$0(18);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(20);
        }
        if (sequence == null) {
            PostgresDialect.$$$reportNull$$$0(21);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, cascade);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(22);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(23);
        }
        if (connection2 == null) {
            PostgresDialect.$$$reportNull$$$0(24);
        }
        String string = PostgresDialectHelper.getTableDefinition(table, connection2);
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            PostgresDialect.$$$reportNull$$$0(26);
        }
        if (connection2 == null) {
            PostgresDialect.$$$reportNull$$$0(27);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element2), true, dbms), DbImplUtil.escapeSql(element2.getName(), true, dbms)), new String[0]);
        if (map == null) {
            PostgresDialect.$$$reportNull$$$0(28);
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            PostgresDialect.$$$reportNull$$$0(29);
        }
        if (connection2 == null) {
            PostgresDialect.$$$reportNull$$$0(30);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map.get("a"));
        Object[] schemas2 = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas2 == null || schemas2.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas2).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            PostgresDialect.$$$reportNull$$$0(31);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first = true;
        for (ObjectPath e : path.elements) {
            if (!first) {
                builder.plain(", ");
            }
            first = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            PostgresDialect.$$$reportNull$$$0(32);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and table_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            PostgresDialect.$$$reportNull$$$0(33);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and routine_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PostgresDialect.$$$reportNull$$$0(34);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection2) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block27: {
            String string;
            if (proc == null) {
                PostgresDialect.$$$reportNull$$$0(35);
            }
            if (connection2 == null) {
                PostgresDialect.$$$reportNull$$$0(36);
            }
            Dbms dbms = connection2.getDbms();
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection2.getMetaData());
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block27;
                string = DbImplUtil.concatStringResults(connection2, dbms, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(37);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PostgresDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PostgresDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        try (ClosableResultsProducer producer = SmartStatements.poweredBy(connection2).simple().noisy().execute(s, StandardExecutionMode.QUERY);){
            ResultSet rs;
            ResultSet resultSet = rs = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
            while (rs != null && rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
                PostgresDialectHelper.SignatureBuilder signatureBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        }
        String string = builder.getStatement();
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            PostgresDialect.$$$reportNull$$$0(39);
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("select\n  'CREATE SEQUENCE ' || '" + DasUtil.getSchema((DasObject)element2) + "' || '.'   || sequence_name\n  || ' INCREMENT BY ' || increment_by\n  || ' MINVALUE ' || min_value\n  || ' MAXVALUE ' || max_value\n  || ' START ' || start_value\n  || ' CACHE ' || cache_value\n  || case when is_cycled then ' CYCLE' else '' end\n  || ';'\nfrom " + builder.qualifiedRef(element2).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PostgresDialect.$$$reportNull$$$0(40);
        }
        return pair;
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(41);
        }
        if (routine == null) {
            PostgresDialect.$$$reportNull$$$0(42);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            PostgresDialect.$$$reportNull$$$0(44);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    public boolean canUnquoteAlias(@NotNull String alias, boolean afterAS) {
        if (alias == null) {
            PostgresDialect.$$$reportNull$$$0(45);
        }
        if (!this.isValidPlainIdentifier(alias)) {
            return false;
        }
        if (afterAS) {
            return true;
        }
        return !DbSqlUtil.getSqlDialect(this.getDbms()).getKeywords().contains(alias);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            PostgresDialect.$$$reportNull$$$0(46);
        }
        if (qualifier == null) {
            PostgresDialect.$$$reportNull$$$0(47);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DataType convertUDTToDataType(@NotNull DasUserDefinedType type) {
        Object delegate;
        if (type == null) {
            PostgresDialect.$$$reportNull$$$0(49);
        }
        if (!((delegate = DbImplUtil.unwrap((DasObject)type)) instanceof PgDefType)) {
            return null;
        }
        List<String> labels = ((PgDefType)delegate).getLabels();
        if (labels.isEmpty()) {
            return null;
        }
        return DataTypeFactory.ofValues(null, null, type.getName(), labels, false);
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            PostgresDialect.$$$reportNull$$$0(50);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(51);
        }
        if (statement == null) {
            PostgresDialect.$$$reportNull$$$0(52);
        }
        builder.keywords("explain").space();
        if (analyze) {
            builder.keyword("analyze").space();
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            PostgresDialect.$$$reportNull$$$0(54);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            PostgresDialect.$$$reportNull$$$0(55);
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return system != null && system.getDbms() != Dbms.REDSHIFT;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(56);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("CTID");
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(57);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/PostgresDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 41: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 26: 
            case 32: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/PostgresDialect";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "convertUDTToDataType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

