/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class ByteArray {
    private final byte[] value;

    public final byte[] getValue() {
        return this.value;
    }

    public final String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        int i = 0;
        int len = this.value.length;
        while (i < len) {
            out.print(ByteArray.formatInt(i, 16, 8));
            out.print("  ");
            int l = Math.min(16, len - i);
            String s = ByteArray.toHexString(this.value, i, l, ' ');
            out.print(s);
            int j = 56 - (56 - s.length());
            while (j < 56) {
                out.print(" ");
                ++j;
            }
            j = 0;
            while (j < l) {
                byte b = this.value[i + j];
                if ((b & 0xFF) < 32 || (b & 0xFF) > 126) {
                    out.print(".");
                } else {
                    out.print((char)(b & 0xFF));
                }
                ++j;
            }
            out.println();
            i += 16;
        }
        return str.toString();
    }

    public static final String toHexString(byte[] buf, int off, int len, char sep) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < len) {
            str.append(Character.forDigit(buf[i + off] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[i + off] & 0xF, 16));
            if (i < len - 1) {
                str.append(sep);
            }
            ++i;
        }
        return str.toString();
    }

    public static final String formatInt(int value, int radix, int len) {
        String s = Integer.toString(value, radix);
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < len - s.length()) {
            buf.append("0");
            ++j;
        }
        buf.append(s);
        return buf.toString();
    }

    public ByteArray(byte[] value) {
        this.value = value;
    }
}

