/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArrayReferenceCommandSet
extends CommandSet {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ThreadGroup;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeLength(bb, os);
                    break;
                }
                case 2: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeSetValues(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Array Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeLength(ByteBuffer bb, DataOutputStream os) throws InvalidObjectException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        os.writeInt(Array.getLength(array));
    }

    private final void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        int first = bb.getInt();
        int length = bb.getInt();
        Class clazz = array.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            os.writeByte(66);
        } else if (clazz == Character.TYPE) {
            os.writeByte(67);
        } else if (clazz == Float.TYPE) {
            os.writeByte(70);
        } else if (clazz == Double.TYPE) {
            os.writeByte(68);
        } else if (clazz == Integer.TYPE) {
            os.writeByte(66);
        } else if (clazz == Long.TYPE) {
            os.writeByte(74);
        } else if (clazz == Short.TYPE) {
            os.writeByte(83);
        } else if (clazz == Void.TYPE) {
            os.writeByte(86);
        } else if (clazz == Boolean.TYPE) {
            os.writeByte(90);
        } else if (clazz.isArray()) {
            os.writeByte(91);
        } else {
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = ArrayReferenceCommandSet.class("[Ljava.lang.String;", false);
            }
            if (clazz2.isAssignableFrom(clazz)) {
                os.writeByte(115);
            } else {
                Class clazz3 = class$java$lang$Thread;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Thread = ArrayReferenceCommandSet.class("[Ljava.lang.Thread;", false);
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    os.writeByte(116);
                } else {
                    Class clazz4 = class$java$lang$ThreadGroup;
                    if (clazz4 == null) {
                        clazz4 = class$java$lang$ThreadGroup = ArrayReferenceCommandSet.class("[Ljava.lang.ThreadGroup;", false);
                    }
                    if (clazz4.isAssignableFrom(clazz)) {
                        os.writeByte(103);
                    } else {
                        Class clazz5 = class$java$lang$ClassLoader;
                        if (clazz5 == null) {
                            clazz5 = class$java$lang$ClassLoader = ArrayReferenceCommandSet.class("[Ljava.lang.ClassLoader;", false);
                        }
                        if (clazz5.isAssignableFrom(clazz)) {
                            os.writeByte(108);
                        } else {
                            Class clazz6 = class$java$lang$Class;
                            if (clazz6 == null) {
                                clazz6 = class$java$lang$Class = ArrayReferenceCommandSet.class("[Ljava.lang.Class;", false);
                            }
                            if (clazz6.isAssignableFrom(clazz)) {
                                os.writeByte(99);
                            } else {
                                os.writeByte(76);
                            }
                        }
                    }
                }
            }
        }
        int i = first;
        while (i < first + length) {
            Object value = Array.get(array, i);
            if (clazz.isPrimitive()) {
                Value.writeUntaggedValue(os, value);
            } else {
                Value.writeTaggedValue(os, value);
            }
            ++i;
        }
    }

    private final void executeSetValues(ByteBuffer bb, DataOutputStream os) throws IOException, JdwpException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        int first = bb.getInt();
        int length = bb.getInt();
        Class type = array.getClass().getComponentType();
        int i = first;
        while (i < first + length) {
            Object value = Value.getUntaggedObj(bb, type);
            Array.set(array, i, value);
            ++i;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

