/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GtkImageConsumer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GtkImage
extends Image {
    static ColorModel nativeModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    int width;
    int height;
    Hashtable props;
    boolean isLoaded;
    Pointer pixmap;
    Vector observers;
    boolean offScreen;
    boolean errorLoading;
    ImageProducer source;

    private final native int[] getPixels();

    private final native void setPixels(int[] var1);

    private final native boolean loadPixbuf(String var1);

    private final native boolean loadImageFromData(byte[] var1);

    private final native void createPixmap();

    private final native void freePixmap();

    private final native void createScaledPixmap(GtkImage var1, int var2);

    private final native void drawPixelsScaled(GdkGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private final native void drawPixelsScaledFlipped(GdkGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    private final native void createFromPixbuf();

    public void setImage(int width, int height, int[] pixels, Hashtable properties) {
        this.width = width;
        this.height = height;
        Hashtable hashtable = this.props = properties != null ? properties : new Hashtable();
        if (width <= 0 || height <= 0 || pixels == null) {
            this.errorLoading = true;
            return;
        }
        this.isLoaded = true;
        this.deliver();
        this.createPixmap();
        this.setPixels(pixels);
    }

    public synchronized int getWidth(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.width;
    }

    public synchronized int getHeight(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.height;
    }

    public synchronized Object getProperty(String name, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return UndefinedProperty;
        }
        Object value = this.props.get(name);
        return value == null ? UndefinedProperty : value;
    }

    public ImageProducer getSource() {
        if (!this.isLoaded) {
            return null;
        }
        return new MemoryImageSource(this.width, this.height, nativeModel, this.getPixels(), 0, this.width);
    }

    public Graphics getGraphics() {
        if (!this.isLoaded) {
            return null;
        }
        if (this.offScreen) {
            return new GdkGraphics(this);
        }
        throw new IllegalAccessError("This method only works for off-screen Images.");
    }

    public Image getScaledInstance(int width, int height, int hints) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new GtkImage(this, width, height, hints);
    }

    public synchronized void flush() {
        if (this.isLoaded && this.source != null) {
            this.observers = new Vector();
            this.isLoaded = false;
            this.freePixmap();
            this.source.startProduction(new GtkImageConsumer(this, this.source));
        }
    }

    public void finalize() {
        if (this.isLoaded) {
            this.freePixmap();
        }
    }

    public int checkImage(ImageObserver observer) {
        if (this.addObserver(observer)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    public boolean drawImage(GdkGraphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int dstY;
        if (this.addObserver(observer)) {
            return false;
        }
        boolean bl = false;
        if (dx1 > dx2) {
            bl = true;
        }
        boolean bl2 = false;
        if (sx1 > sx2) {
            bl2 = true;
        }
        boolean flipX = bl ^ bl2;
        boolean bl3 = false;
        if (dy1 > dy2) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (sy1 > sy2) {
            bl4 = true;
        }
        boolean flipY = bl3 ^ bl4;
        int dstWidth = Math.abs(dx2 - dx1);
        int dstHeight = Math.abs(dy2 - dy1);
        int srcWidth = Math.abs(sx2 - sx1);
        int srcHeight = Math.abs(sy2 - sy1);
        int srcX = sx1 < sx2 ? sx1 : sx2;
        int srcY = sy1 < sy2 ? sy1 : sy2;
        int dstX = dx1 < dx2 ? dx1 : dx2;
        int n = dstY = dy1 < dy2 ? dy1 : dy2;
        if (srcWidth > this.width) {
            dstWidth = (int)((double)dstWidth * ((double)this.width / (double)srcWidth));
            srcWidth = this.width - srcX;
        }
        if (srcHeight > this.height) {
            dstHeight = (int)((double)dstHeight * ((double)this.height / (double)srcHeight));
            srcHeight = this.height - srcY;
        }
        if (srcWidth + srcX > this.width) {
            dstWidth = (int)((double)dstWidth * (double)(this.width - srcX) / (double)srcWidth);
            srcWidth = this.width - srcX;
        }
        if (srcHeight + srcY > this.height) {
            dstHeight = (int)((double)dstHeight * (double)(this.width - srcY) / (double)srcHeight);
            srcHeight = this.height - srcY;
        }
        if (srcWidth <= 0 || srcHeight <= 0 || dstWidth <= 0 || dstHeight <= 0) {
            return true;
        }
        if (bgcolor != null) {
            this.drawPixelsScaledFlipped(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, true);
        } else {
            this.drawPixelsScaledFlipped(g, 0, 0, 0, flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, false);
        }
        return true;
    }

    public boolean drawImage(GdkGraphics g, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return false;
        }
        if (bgcolor != null) {
            this.drawPixelsScaled(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), x, y, width, height, true);
        } else {
            this.drawPixelsScaled(g, 0, 0, 0, x, y, width, height, false);
        }
        return true;
    }

    private final void deliver() {
        int flags = 39;
        if (this.observers != null) {
            int i = 0;
            while (i < this.observers.size()) {
                ((ImageObserver)this.observers.elementAt(i)).imageUpdate(this, flags, 0, 0, this.width, this.height);
                ++i;
            }
        }
        this.observers = null;
    }

    private final boolean addObserver(ImageObserver observer) {
        if (!this.isLoaded) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.addElement(observer);
            }
            return true;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.width = -1;
        this.height = -1;
    }

    public GtkImage(ImageProducer producer) {
        this.this();
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = producer;
        this.errorLoading = false;
        this.source.startProduction(new GtkImageConsumer(this, this.source));
        this.offScreen = false;
    }

    public GtkImage() {
        this.this();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    public GtkImage(String filename) {
        this.this();
        File f = new File(filename);
        try {
            if (!this.loadPixbuf(f.getCanonicalPath())) {
                throw new IllegalArgumentException("Couldn't load image: " + filename);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't load image: " + filename);
        }
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
    }

    public GtkImage(byte[] data) {
        this.this();
        if (!this.loadImageFromData(data)) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    public GtkImage(URL url) {
        this.this();
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (url == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        try {
            BufferedInputStream bis = new BufferedInputStream(url.openStream());
            byte[] buf = new byte[5000];
            int n = 0;
            while ((n = bis.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            bis.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        if (!this.loadImageFromData(baos.toByteArray())) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    public GtkImage(int width, int height) {
        this.this();
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = true;
        this.createPixmap();
    }

    private GtkImage(GtkImage src, int width, int height, int hints) {
        this.this();
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.createScaledPixmap(src, hints);
    }

    GtkImage(Pointer pixbuf) {
        this.this();
        this.pixmap = pixbuf;
        this.createFromPixbuf();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
    }
}

