/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeBF16
extends BMPDecoder {
    private int[] bitmasks;
    private boolean useDefaultMasks;

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        if (!this.useDefaultMasks) {
            this.bitmasks = this.readBitMasks(in);
        }
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        int scansize = w + (w & 1) << 1;
        short[] data = new short[w * h];
        int y = h - 1;
        while (y >= 0) {
            byte[] scanline = new byte[scansize];
            if (in.read(scanline) != scansize) {
                throw new IOException("Couldn't read image data.");
            }
            int x = 0;
            while (x < w) {
                data[x + y * w] = (short)(scanline[x * 2] & 0xFF | (scanline[x * 2 + 1] & 0xFF) << 8);
                ++x;
            }
            --y;
        }
        DirectColorModel cm = new DirectColorModel(16, this.bitmasks[0], this.bitmasks[1], this.bitmasks[2]);
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(1, w, h, this.bitmasks);
        DataBufferUShort db = new DataBufferUShort(data, w * h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, raster, false, null);
    }

    public DecodeBF16(BMPFileHeader fh, BMPInfoHeader ih, boolean udm) {
        super(fh, ih);
        this.useDefaultMasks = udm;
        if (this.useDefaultMasks) {
            this.bitmasks = new int[]{63488, 2016, 31};
        }
    }
}

