/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.html2.DomHTMLImpl;
import gnu.xml.dom.ls.DomLSInput;
import gnu.xml.dom.ls.DomLSOutput;
import gnu.xml.dom.ls.DomLSParser;
import gnu.xml.dom.ls.DomLSSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class DomImpl
implements DOMImplementation,
DOMImplementationLS {
    public boolean hasFeature(String name, String version) {
        if (name.length() == 0) {
            return false;
        }
        if ((name = name.toLowerCase()).charAt(0) == '+') {
            name = name.substring(1);
        }
        if ("xml".equals(name) || "core".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "1.0".equals(version) || "2.0".equals(version) || "3.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("ls".equals(name) || "ls-async".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "3.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("events".equals(name) || "mutationevents".equals(name) || "uievents".equals(name) || "htmlevents".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "2.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("user-events".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "0.1".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("traversal".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "2.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("xpath".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "3.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("html".equals(name) || "xhtml".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "2.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public DocumentType createDocumentType(String rootName, String publicId, String systemId) {
        DomDocument.checkNCName(rootName, false);
        return new DomDoctype(this, rootName, publicId, systemId, null);
    }

    public Document createDocument(String namespaceURI, String rootName, DocumentType doctype) {
        Document doc = this.createDocument();
        Element root = null;
        if (rootName != null) {
            root = doc.createElementNS(namespaceURI, rootName);
            if (rootName.startsWith("xmlns:")) {
                throw new DomDOMException(14, "xmlns is reserved", null, 0);
            }
        }
        if (doctype != null) {
            doc.appendChild(doctype);
        }
        if (root != null) {
            doc.appendChild(root);
        }
        return doc;
    }

    protected Document createDocument() {
        return new DomDocument(this);
    }

    public Object getFeature(String feature, String version) {
        if (this.hasFeature(feature, version)) {
            if ("html".equalsIgnoreCase(feature) || "xhtml".equalsIgnoreCase(feature)) {
                return new DomHTMLImpl();
            }
            return this;
        }
        return null;
    }

    public LSParser createLSParser(short mode, String schemaType) throws DOMException {
        return new DomLSParser(mode, schemaType);
    }

    public LSSerializer createLSSerializer() {
        return new DomLSSerializer();
    }

    public LSInput createLSInput() {
        return new DomLSInput();
    }

    public LSOutput createLSOutput() {
        return new DomLSOutput();
    }
}

