/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Key;
import gnu.xml.transform.Stylesheet;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Function;
import gnu.xml.xpath.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class KeyFunction
extends Pattern
implements XPathFunction,
Function {
    final Stylesheet stylesheet;
    List args;

    public final Object evaluate(List args) throws XPathFunctionException {
        return Collections.EMPTY_SET;
    }

    public final void setArguments(List args) {
        this.args = args;
    }

    public final boolean matches(Node context) {
        Object ret = this.evaluate(context, 1, 1);
        return ((Collection)ret).isEmpty() ^ true;
    }

    public final Object evaluate(Node context, int pos, int len) {
        Document doc;
        int arity = this.args.size();
        ArrayList values = new ArrayList(arity);
        int i = 0;
        while (i < arity) {
            Expr arg = (Expr)this.args.get(i);
            values.add(arg.evaluate(context, pos, len));
            ++i;
        }
        QName keyName = QName.valueOf(KeyFunction._string(context, values.get(0)));
        String uri = keyName.getNamespaceURI();
        String prefix = keyName.getPrefix();
        if ((uri == null || uri.length() == 0) && prefix != null && prefix.length() > 0 && (uri = this.stylesheet.getNamespaceURI(prefix)) != null && uri.length() > 0) {
            String localName = keyName.getLocalPart();
            keyName = new QName(uri, localName, prefix);
        }
        LinkedList keySet = new LinkedList();
        Iterator i2 = this.stylesheet.keys.iterator();
        while (i2.hasNext()) {
            Key key = (Key)i2.next();
            if (!key.name.equals(keyName)) continue;
            keySet.add(key);
        }
        Object target = values.get(1);
        LinkedHashSet acc = new LinkedHashSet();
        Document document = doc = context instanceof Document ? (Document)context : context.getOwnerDocument();
        if (target instanceof Collection) {
            Iterator i3 = ((Collection)target).iterator();
            while (i3.hasNext()) {
                String val = Expr.stringValue((Node)i3.next());
                this.addKeyNodes(doc, keySet, val, acc);
            }
        } else {
            String val = Expr._string(context, target);
            this.addKeyNodes(doc, keySet, val, acc);
        }
        ArrayList ret = new ArrayList(acc);
        Collections.sort(ret, documentOrderComparator);
        return ret;
    }

    final void addKeyNodes(Node node2, Collection keySet, String value, Collection acc) {
        this.addKeyNodeIfMatch(node2, keySet, value, acc);
        Node ctx = node2.getFirstChild();
        while (ctx != null) {
            this.addKeyNodes(ctx, keySet, value, acc);
            ctx = ctx.getNextSibling();
        }
    }

    final void addKeyNodeIfMatch(Node node2, Collection keySet, String value, Collection acc) {
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            Key key = (Key)i.next();
            if (!key.match.matches(node2)) continue;
            Object eval = key.use.evaluate(node2, 1, 1);
            if (eval instanceof Collection) {
                Iterator j = ((Collection)eval).iterator();
                while (j.hasNext()) {
                    String keyValue = Expr.stringValue((Node)j.next());
                    if (!value.equals(keyValue)) continue;
                    acc.add(node2);
                    return;
                }
                continue;
            }
            String keyValue = Expr._string(node2, eval);
            if (!value.equals(keyValue)) continue;
            acc.add(node2);
            return;
        }
    }

    public final Expr clone(Object context) {
        Stylesheet s = this.stylesheet;
        if (context instanceof Stylesheet) {
            s = (Stylesheet)context;
        }
        KeyFunction f = new KeyFunction(s);
        int len = this.args.size();
        ArrayList args2 = new ArrayList(len);
        int i = 0;
        while (i < len) {
            args2.add(((Expr)this.args.get(i)).clone(context));
            ++i;
        }
        f.setArguments(args2);
        return f;
    }

    public final boolean references(QName var) {
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (!((Expr)i.next()).references(var)) continue;
            return true;
        }
        return false;
    }

    KeyFunction(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }
}

