/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.charset.EncodingHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InputStreamReader
extends Reader {
    private InputStream in;
    private CharsetDecoder decoder;
    private boolean isDone;
    private float maxBytesPerChar;
    private ByteBuffer byteBuffer;
    private String encoding;
    private char savedSurrogate;
    private boolean hasSavedSurrogate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.decoder != null) {
                this.decoder.reset();
            }
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.isDone = true;
            this.decoder = null;
            return;
        }
    }

    public String getEncoding() {
        return this.in != null ? this.encoding : null;
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        boolean bl = false;
        if (this.in.available() != 0) {
            bl = true;
        }
        return bl;
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        if (this.isDone) {
            return -1;
        }
        if (this.decoder != null) {
            int read;
            int totalBytes = (int)((double)length * (double)this.maxBytesPerChar);
            byte[] bytes = new byte[totalBytes];
            int remaining = 0;
            if (this.byteBuffer != null) {
                remaining = this.byteBuffer.remaining();
                this.byteBuffer.get(bytes, 0, remaining);
            }
            if (totalBytes - remaining > 0) {
                read = this.in.read(bytes, remaining, totalBytes - remaining);
                if (read == -1) {
                    read = remaining;
                    this.isDone = true;
                } else {
                    read += remaining;
                }
            } else {
                read = remaining;
            }
            this.byteBuffer = ByteBuffer.wrap(bytes, 0, read);
            CharBuffer cb = CharBuffer.wrap(buf, offset, length);
            int startPos = cb.position();
            if (this.hasSavedSurrogate) {
                this.hasSavedSurrogate = false;
                cb.put(this.savedSurrogate);
                ++read;
            }
            CoderResult cr = this.decoder.decode(this.byteBuffer, cb, this.isDone);
            this.decoder.reset();
            if (cr.isOverflow() && cb.hasRemaining()) {
                CharBuffer overflowbuf = CharBuffer.allocate(2);
                cr = this.decoder.decode(this.byteBuffer, overflowbuf, this.isDone);
                overflowbuf.flip();
                if (overflowbuf.hasRemaining()) {
                    cb.put(overflowbuf.get());
                    this.savedSurrogate = overflowbuf.get();
                    this.hasSavedSurrogate = true;
                    this.isDone = false;
                }
            }
            if (this.byteBuffer.hasRemaining()) {
                this.byteBuffer.compact();
                this.byteBuffer.flip();
                this.isDone = false;
            } else {
                this.byteBuffer = null;
            }
            read = cb.position() - startPos;
            return read <= 0 ? -1 : read;
        }
        byte[] bytes = new byte[length];
        int read = this.in.read(bytes);
        int i = 0;
        while (i < read) {
            buf[offset + i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        return read;
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        int count = this.read(buf, 0, 1);
        return count > 0 ? buf[0] : -1;
    }

    public long skip(long count) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        return super.skip(count);
    }

    private final /* synthetic */ void this() {
        this.isDone = false;
        this.hasSavedSurrogate = false;
    }

    public InputStreamReader(InputStream in) {
        this.this();
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
        try {
            this.encoding = System.getProperty("file.encoding");
            if (EncodingHelper.isISOLatin1(this.encoding)) {
                this.encoding = "ISO8859_1";
                this.maxBytesPerChar = 1.0f;
                this.decoder = null;
                return;
            }
            Charset cs = EncodingHelper.getCharset(this.encoding);
            this.decoder = cs.newDecoder();
            this.encoding = EncodingHelper.getOldCanonical(cs.name());
            try {
                this.maxBytesPerChar = cs.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException _) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
        }
        catch (RuntimeException e) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
        catch (UnsupportedEncodingException e) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream in, String encoding_name) throws UnsupportedEncodingException {
        this.this();
        if (in == null || encoding_name == null) {
            throw new NullPointerException();
        }
        this.in = in;
        if (EncodingHelper.isISOLatin1(encoding_name)) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
            return;
        }
        try {
            Charset cs = EncodingHelper.getCharset(encoding_name);
            try {
                this.maxBytesPerChar = cs.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException _) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder = cs.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
            this.encoding = EncodingHelper.getOldCanonical(cs.name());
        }
        catch (RuntimeException e) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream in, Charset charset) {
        this.this();
        this.in = in;
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.reset();
        this.encoding = EncodingHelper.getOldCanonical(charset.name());
    }

    public InputStreamReader(InputStream in, CharsetDecoder decoder) {
        this.this();
        this.in = in;
        this.decoder = decoder;
        try {
            this.maxBytesPerChar = decoder.charset().newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedOperationException _) {
            this.maxBytesPerChar = 1.0f;
        }
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.reset();
        this.encoding = EncodingHelper.getOldCanonical(decoder.charset().name());
    }
}

