/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.classpath.SystemProperties;
import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.DatagramChannelImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DatagramSocket {
    private static DatagramSocketImplFactory factory;
    private DatagramSocketImpl impl;
    private boolean implCreated;
    private InetAddress remoteAddress;
    private int remotePort;
    private boolean bound;

    DatagramSocketImpl getImpl() throws SocketException {
        try {
            if (!this.implCreated) {
                this.impl.create();
                this.implCreated = true;
            }
            return this.impl;
        }
        catch (IOException e) {
            SocketException se = new SocketException();
            se.initCause(e);
            throw se;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            try {
                this.getImpl().close();
            }
            catch (SocketException e) {}
            Object var2_4 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            this.impl = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            this.impl = null;
            throw throwable;
        }
        {
            if (this.getChannel() == null) return;
            this.getChannel().close();
            return;
        }
    }

    public InetAddress getInetAddress() {
        return this.remoteAddress;
    }

    public int getPort() {
        return this.remotePort;
    }

    public InetAddress getLocalAddress() {
        InetAddress localAddr;
        if (!this.isBound()) {
            return null;
        }
        try {
            localAddr = (InetAddress)this.getImpl().getOption(15);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkConnect(localAddr.getHostName(), -1);
            }
        }
        catch (SecurityException e) {
            localAddr = InetAddress.ANY_IF;
        }
        catch (SocketException e) {
            return null;
        }
        return localAddr;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4102);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("unexpected type");
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.getImpl().setOption(4102, new Integer(timeout));
    }

    public int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4097);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("unexpected type");
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.getImpl().setOption(4097, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4098);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("unexpected type");
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.getImpl().setOption(4098, new Integer(size));
    }

    public void connect(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("Connect address may not be null");
        }
        if (port < 1 || port > (char)-1) {
            throw new IllegalArgumentException("Port number is illegal: " + port);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(address.getHostName(), port);
        }
        try {
            this.getImpl().connect(address, port);
            this.remoteAddress = address;
            this.remotePort = port;
        }
        catch (SocketException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            try {
                this.getImpl().disconnect();
            }
            catch (SocketException socketException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            return;
        }
    }

    public synchronized void receive(DatagramPacket p) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (this.remoteAddress != null && this.remoteAddress.isMulticastAddress()) {
            throw new IOException("Socket connected to a multicast address my not receive");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((DatagramChannelImpl)this.getChannel()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.getImpl().receive(p);
        SecurityManager s = System.getSecurityManager();
        if (s != null && this.isConnected()) {
            s.checkAccept(p.getAddress().getHostName(), p.getPort());
        }
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null && !this.isConnected()) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkMulticast(addr);
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        if (this.isConnected() && p.getAddress() != null && (this.remoteAddress != p.getAddress() || this.remotePort != p.getPort())) {
            throw new IllegalArgumentException("DatagramPacket address does not match remote address");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((DatagramChannelImpl)this.getChannel()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.getImpl().send(p);
    }

    public void bind(SocketAddress address) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetAddress addr = ((InetSocketAddress)address).getAddress();
        int port = ((InetSocketAddress)address).getPort();
        if (port < 0 || port > (char)-1) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        if (addr == null) {
            addr = InetAddress.ANY_IF;
        }
        try {
            this.getImpl().bind(port, addr);
            this.bound = true;
        }
        catch (SocketException exception) {
            this.getImpl().close();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.getImpl().close();
            throw exception;
        }
        catch (Error error) {
            this.getImpl().close();
            throw error;
        }
    }

    public boolean isClosed() {
        boolean bl = false;
        if (this.impl == null) {
            bl = true;
        }
        return bl;
    }

    public DatagramChannel getChannel() {
        return null;
    }

    public void connect(SocketAddress address) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress tmp = (InetSocketAddress)address;
        this.connect(tmp.getAddress(), tmp.getPort());
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.remoteAddress != null) {
            bl = true;
        }
        return bl;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.remoteAddress, this.remotePort);
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4, on);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(4);
        if (buf instanceof Boolean) {
            return (Boolean)buf;
        }
        throw new SocketException("unexpected type");
    }

    public void setBroadcast(boolean enable) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(32, enable);
    }

    public boolean getBroadcast() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(32);
        if (buf instanceof Boolean) {
            return (Boolean)buf;
        }
        throw new SocketException("unexpected type");
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException();
        }
        this.getImpl().setOption(3, new Integer(tc));
    }

    public int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(3);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("unexpected type");
    }

    public static void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("DatagramSocketImplFactory already defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        factory = fac;
    }

    private final /* synthetic */ void this() {
        this.remotePort = -1;
    }

    protected DatagramSocket(DatagramSocketImpl impl) {
        this.this();
        if (impl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = impl;
        this.remoteAddress = null;
        this.remotePort = -1;
    }

    public DatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    public DatagramSocket(int port) throws SocketException {
        this(new InetSocketAddress(port));
    }

    public DatagramSocket(int port, InetAddress addr) throws SocketException {
        this(new InetSocketAddress(addr, port));
    }

    public DatagramSocket(SocketAddress address) throws SocketException {
        this.this();
        String propVal = SystemProperties.getProperty("impl.prefix");
        if (propVal == null || propVal.equals("")) {
            this.impl = new PlainDatagramSocketImpl();
        } else {
            try {
                this.impl = (DatagramSocketImpl)Class.forName("java.net." + propVal + "DatagramSocketImpl").newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate class: java.net." + propVal + "DatagramSocketImpl");
                this.impl = new PlainDatagramSocketImpl();
            }
        }
        if (address != null) {
            this.bind(address);
        }
    }
}

