/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharBufferImpl
extends CharBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final CharBuffer slice() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final CharBuffer duplicate() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final CharBuffer asReadOnlyBuffer() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final CharBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final CharSequence subSequence(int start, int end) {
        if (start < 0 || start > this.length() || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.position() + end, this.position() + start, -1, this.isReadOnly());
    }

    public final char get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backing_buffer[this.pos++ + this.array_offset];
    }

    public final CharBuffer put(char value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.pos >= this.limit) {
            throw new BufferOverflowException();
        }
        this.backing_buffer[this.pos++ + this.array_offset] = value;
        return this;
    }

    public final char get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index + this.array_offset];
    }

    public final CharBuffer get(char[] dst, int offset, int length) {
        CharBufferImpl.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        System.arraycopy(this.backing_buffer, this.pos + this.array_offset, dst, offset, length);
        this.pos += length;
        return this;
    }

    public final CharBuffer put(char[] src, int offset, int length) {
        CharBufferImpl.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        System.arraycopy(src, offset, this.backing_buffer, this.pos + this.array_offset, length);
        this.pos += length;
        return this;
    }

    public final CharBuffer put(int index, char value) {
        this.checkIndex(index);
        this.checkIfReadOnly();
        this.backing_buffer[index + this.array_offset] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    CharBufferImpl(int capacity) {
        this(new char[capacity], 0, capacity, capacity, 0, -1, false);
    }

    CharBufferImpl(char[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
        this.readOnly = readOnly;
    }

    public CharBufferImpl(CharBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.array_offset = copy.array_offset;
        this.readOnly = copy.isReadOnly();
    }
}

