/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DirectByteBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;
import java.nio.VMDirectByteBuffer;

final class MappedByteBufferImpl
extends MappedByteBuffer {
    boolean readOnly;
    public Pointer implPtr;
    public long implLen;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final byte get() {
        this.checkForUnderflow();
        int pos = this.position();
        byte result = VMDirectByteBuffer.get(this.address, pos);
        this.position(pos + 1);
        return result;
    }

    public final ByteBuffer put(byte value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        int pos = this.position();
        VMDirectByteBuffer.put(this.address, pos, value);
        this.position(pos + 1);
        return this;
    }

    public final byte get(int index) {
        this.checkIndex(index);
        return VMDirectByteBuffer.get(this.address, index);
    }

    public final ByteBuffer get(byte[] dst, int offset, int length) {
        MappedByteBufferImpl.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int index = this.position();
        VMDirectByteBuffer.get(this.address, index, dst, offset, length);
        this.position(index + length);
        return this;
    }

    public final ByteBuffer put(int index, byte value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        VMDirectByteBuffer.put(this.address, index, value);
        return this;
    }

    public final ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int pos = this.position();
        if (pos > 0) {
            int count = this.remaining();
            VMDirectByteBuffer.shiftDown(this.address, 0, pos, count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final boolean isDirect() {
        return true;
    }

    public final ByteBuffer slice() {
        int rem = this.remaining();
        if (this.isReadOnly()) {
            return new DirectByteBufferImpl.ReadOnly(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), rem, rem, 0);
        }
        return new DirectByteBufferImpl.ReadWrite(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), rem, rem, 0);
    }

    private final ByteBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        DirectByteBufferImpl result = readOnly ? new DirectByteBufferImpl.ReadOnly(this, this.address, this.capacity(), this.limit(), pos) : new DirectByteBufferImpl.ReadWrite(this, this.address, this.capacity(), this.limit(), pos);
        if (mark != pos) {
            result.position(mark);
            result.mark();
            result.position(pos);
        }
        return result;
    }

    public final ByteBuffer duplicate() {
        return this.duplicate(this.isReadOnly());
    }

    public final ByteBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public final CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public final ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public final IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public final LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public final FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public final char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public final ByteBuffer putChar(char value) {
        ByteBufferHelper.putChar(this, value, this.order());
        return this;
    }

    public final char getChar(int index) {
        return ByteBufferHelper.getChar(this, index, this.order());
    }

    public final ByteBuffer putChar(int index, char value) {
        ByteBufferHelper.putChar(this, index, value, this.order());
        return this;
    }

    public final short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public final ByteBuffer putShort(short value) {
        ByteBufferHelper.putShort(this, value, this.order());
        return this;
    }

    public final short getShort(int index) {
        return ByteBufferHelper.getShort(this, index, this.order());
    }

    public final ByteBuffer putShort(int index, short value) {
        ByteBufferHelper.putShort(this, index, value, this.order());
        return this;
    }

    public final int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public final ByteBuffer putInt(int value) {
        ByteBufferHelper.putInt(this, value, this.order());
        return this;
    }

    public final int getInt(int index) {
        return ByteBufferHelper.getInt(this, index, this.order());
    }

    public final ByteBuffer putInt(int index, int value) {
        ByteBufferHelper.putInt(this, index, value, this.order());
        return this;
    }

    public final long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public final ByteBuffer putLong(long value) {
        ByteBufferHelper.putLong(this, value, this.order());
        return this;
    }

    public final long getLong(int index) {
        return ByteBufferHelper.getLong(this, index, this.order());
    }

    public final ByteBuffer putLong(int index, long value) {
        ByteBufferHelper.putLong(this, index, value, this.order());
        return this;
    }

    public final float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public final ByteBuffer putFloat(float value) {
        ByteBufferHelper.putFloat(this, value, this.order());
        return this;
    }

    public final float getFloat(int index) {
        return ByteBufferHelper.getFloat(this, index, this.order());
    }

    public final ByteBuffer putFloat(int index, float value) {
        ByteBufferHelper.putFloat(this, index, value, this.order());
        return this;
    }

    public final double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public final ByteBuffer putDouble(double value) {
        ByteBufferHelper.putDouble(this, value, this.order());
        return this;
    }

    public final double getDouble(int index) {
        return ByteBufferHelper.getDouble(this, index, this.order());
    }

    public final ByteBuffer putDouble(int index, double value) {
        ByteBufferHelper.putDouble(this, index, value, this.order());
        return this;
    }

    final native void unmapImpl();

    final native boolean isLoadedImpl();

    final native void loadImpl();

    final native void forceImpl();

    public MappedByteBufferImpl(Pointer address, int size, boolean readOnly) throws IOException {
        super(size, size, 0, -1);
        this.address = address;
        this.readOnly = readOnly;
    }
}

