/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value) {
        this.addAttribute(attrib, value, 0, this.sci.getEndIndex());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value, int begin, int end) {
        if (attrib == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (end <= begin) {
            throw new IllegalArgumentException("Requires end > begin");
        }
        HashMap hm = new HashMap();
        hm.put(attrib, value);
        this.addAttributes(hm, begin, end);
    }

    public void addAttributes(Map attributes, int begin_index, int end_index) {
        if (attributes == null) {
            throw new NullPointerException("null attribute");
        }
        if (begin_index < 0 || end_index > this.sci.getEndIndex() || end_index <= begin_index) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] new_list = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, new_list, 0, this.attribs.length);
        this.attribs = new_list;
        this.attribs[this.attribs.length - 1] = new AttributeRange(attributes, begin_index, end_index);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex(), null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return this.getIterator(attributes, 0, this.sci.getEndIndex());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int begin_index, int end_index) {
        if (begin_index < 0 || end_index > this.sci.getEndIndex() || end_index < begin_index) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, begin_index, end_index, attributes);
    }

    public AttributedString(String str) {
        this.sci = new StringCharacterIterator(str);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String str, Map attributes) {
        this(str);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(attributes, 0, str.length());
    }

    public AttributedString(AttributedCharacterIterator aci) {
        this(aci, aci.getBeginIndex(), aci.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator aci, int begin_index, int end_index) {
        this(aci, begin_index, end_index, null);
    }

    public AttributedString(AttributedCharacterIterator aci, int begin, int end, AttributedCharacterIterator.Attribute[] attributes) {
        if (begin < 0 || end < begin || end > aci.getEndIndex()) {
            throw new IllegalArgumentException("Bad index values");
        }
        StringBuffer sb = new StringBuffer("");
        Set all_attribs = aci.getAllAttributeKeys();
        if (attributes != null) {
            all_attribs.retainAll(Arrays.asList(attributes));
        }
        char c = aci.setIndex(begin);
        ArrayList accum = new ArrayList();
        do {
            sb.append(c);
            Iterator iter = all_attribs.iterator();
            while (iter.hasNext()) {
                AttributedCharacterIterator.Attribute attrib;
                int rl;
                Object obj = iter.next();
                if (!(obj instanceof AttributedCharacterIterator.Attribute) || (rl = aci.getRunLimit(attrib = (AttributedCharacterIterator.Attribute)obj)) == -1) continue;
                if (rl > end) {
                    rl = end;
                }
                rl -= begin;
                int rs = aci.getRunStart(attrib);
                if (rs < aci.getIndex() && aci.getIndex() != begin) continue;
                Object attrib_obj = aci.getAttribute(attrib);
                if (rs < begin) {
                    if (attrib_obj instanceof Annotation) continue;
                    rs = begin;
                } else {
                    rs -= begin;
                }
                Hashtable new_map = new Hashtable();
                new_map.put(attrib, attrib_obj);
                accum.add(new AttributeRange(new_map, rs, rl));
            }
        } while ((c = aci.next()) != (char)-1);
        this.attribs = new AttributeRange[accum.size()];
        this.attribs = (AttributeRange[])accum.toArray(this.attribs);
        this.sci = new StringCharacterIterator(sb.toString());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class AttributeRange {
        Map attribs;
        int begin_index;
        int end_index;

        AttributeRange(Map attribs, int begin_index, int end_index) {
            this.attribs = attribs;
            this.begin_index = begin_index;
            this.end_index = end_index;
        }
    }
}

