/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;

public class EncryptedPrivateKeyInfo {
    private byte[] encryptedData;
    private byte[] encoded;
    private OID algOid;
    private AlgorithmParameters params;
    private byte[] encodedParams;

    public String getAlgName() {
        return this.algOid.toString();
    }

    public AlgorithmParameters getAlgParameters() {
        if (this.params == null && this.encodedParams != null) {
            try {
                this.params = AlgorithmParameters.getInstance(this.getAlgName());
                this.params.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException ignore) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.params;
    }

    public synchronized byte[] getEncoded() throws IOException {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            return new PKCS8EncodedKeySpec(cipher.doFinal(this.encryptedData));
        }
        catch (Exception x) {
            throw new InvalidKeySpecException(x.toString());
        }
    }

    private final void decode() throws IOException {
        DERReader der = new DERReader(this.encoded);
        DERValue val = der.read();
        if (val.getTag() != 16) {
            throw new IOException("malformed EncryptedPrivateKeyInfo");
        }
        val = der.read();
        if (val.getTag() != 16) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        int algpLen = val.getLength();
        DERValue oid = der.read();
        if (oid.getTag() != 6) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.algOid = (OID)oid.getValue();
        if (algpLen == 0) {
            val = der.read();
            if (val.getTag() != 0) {
                this.encodedParams = val.getEncoded();
                der.read();
            }
        } else if (oid.getEncodedLength() < val.getLength()) {
            val = der.read();
            this.encodedParams = val.getEncoded();
        }
        val = der.read();
        if (val.getTag() != 4) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.encryptedData = (byte[])val.getValue();
    }

    private final void encode() throws IOException {
        ArrayList algId = new ArrayList(2);
        algId.add(new DERValue(6, this.algOid));
        this.getAlgParameters();
        if (this.params != null) {
            algId.add(DERReader.read(this.params.getEncoded()));
        }
        ArrayList epki = new ArrayList(2);
        epki.add(new DERValue(48, algId));
        epki.add(new DERValue(4, this.encryptedData));
        this.encoded = new DERValue(48, epki).getEncoded();
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters params, byte[] encryptedData) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (encryptedData.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.params = params;
        this.algOid = new OID(params.getAlgorithm());
        this.encryptedData = (byte[])encryptedData.clone();
    }

    public EncryptedPrivateKeyInfo(byte[] encoded) throws IOException {
        this.encoded = (byte[])encoded.clone();
        this.decode();
    }

    public EncryptedPrivateKeyInfo(String algName, byte[] encryptedData) throws IllegalArgumentException, NoSuchAlgorithmException, NullPointerException {
        if (encryptedData.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.algOid = new OID(algName);
        this.encryptedData = (byte[])encryptedData.clone();
    }
}

