/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 3564035141373880027L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart;

    public Component getComponent() {
        return this.editorComponent;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
        return this.delegate.isCellEditable(event);
    }

    public boolean shouldSelectCell(EventObject event) {
        return this.delegate.shouldSelectCell(event);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.editorComponent instanceof JTextField) {
            ((JTextField)this.editorComponent).setText(value.toString());
            this.delegate = new EditorDelegate();
            ((JTextField)this.editorComponent).addActionListener(this.delegate);
        } else if (this.editorComponent instanceof JCheckBox) {
            ((JCheckBox)this.editorComponent).setText(value.toString());
            this.delegate = new EditorDelegate();
            ((JCheckBox)this.editorComponent).addActionListener(this.delegate);
        } else if (this.editorComponent instanceof JComboBox) {
            ((JComboBox)this.editorComponent).setSelectedItem(value.toString());
            this.delegate = new EditorDelegate();
            ((JComboBox)this.editorComponent).addActionListener(this.delegate);
        }
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.editorComponent instanceof JTextField) {
            ((JTextField)this.editorComponent).setText(value.toString());
            this.delegate = new EditorDelegate();
            ((JTextField)this.editorComponent).addActionListener(this.delegate);
        }
        return this.editorComponent;
    }

    public DefaultCellEditor(JTextField textfield) {
        this.editorComponent = textfield;
        this.clickCountToStart = 3;
    }

    public DefaultCellEditor(JCheckBox checkbox) {
        this.editorComponent = checkbox;
        this.clickCountToStart = 1;
    }

    public DefaultCellEditor(JComboBox combobox) {
        this.editorComponent = combobox;
        this.clickCountToStart = 1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private static final long serialVersionUID = -1420007406015481933L;
        protected Object value;

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject event) {
            return event == null || !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= DefaultCellEditor.this.getClickCountToStart();
        }

        public boolean shouldSelectCell(EventObject event) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public boolean startCellEditing(EventObject event) {
            return true;
        }

        public void actionPerformed(ActionEvent event) {
            this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent event) {
            this.stopCellEditing();
        }

        void fireEditingStopped() {
            CellEditorListener[] listeners = DefaultCellEditor.this.getCellEditorListeners();
            int index = 0;
            while (index < listeners.length) {
                listeners[index].editingStopped(DefaultCellEditor.this.changeEvent);
                ++index;
            }
        }

        void fireEditingCanceled() {
            CellEditorListener[] listeners = DefaultCellEditor.this.getCellEditorListeners();
            int index = 0;
            while (index < listeners.length) {
                listeners[index].editingCanceled(DefaultCellEditor.this.changeEvent);
                ++index;
            }
        }

        protected EditorDelegate() {
        }
    }
}

