/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final long serialVersionUID = 5654585963292734470L;
    private static final int DEFAULT_MAXIMUM_ROW_COUNT = 8;
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount;
    protected boolean isEditable;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand;
    protected boolean lightWeightPopupEnabled;
    private Action action;
    private Object prototypeDisplayValue;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$javax$swing$event$PopupMenuListener;

    public boolean isEditable() {
        return this.isEditable;
    }

    protected void installAncestorListener() {
    }

    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ComboBoxUI";
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel newDataModel) {
        if (this.dataModel != null) {
            if (this.dataModel == newDataModel) {
                return;
            }
            this.dataModel.removeListDataListener(this);
        }
        newDataModel.addListDataListener(this);
        ComboBoxModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.selectedItemReminder = newDataModel.getSelectedItem();
        this.firePropertyChange("model", oldDataModel, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            this.firePropertyChange("editable", this.isEditable ^ true, this.isEditable);
        }
    }

    public void setMaximumRowCount(int rowCount) {
        if (this.maximumRowCount != rowCount) {
            int oldMaximumRowCount = this.maximumRowCount;
            this.maximumRowCount = rowCount;
            this.firePropertyChange("maximumRowCount", oldMaximumRowCount, this.maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        if (this.renderer != aRenderer) {
            ListCellRenderer oldRenderer = this.renderer;
            this.renderer = aRenderer;
            this.firePropertyChange("renderer", oldRenderer, this.renderer);
        }
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        ComboBoxEditor oldEditor = this.editor;
        this.editor = newEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", oldEditor, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object item) {
        this.dataModel.setSelectedItem(item);
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int index) {
        if (index < -1 || index >= this.dataModel.getSize()) {
            throw new IllegalArgumentException("illegal index: " + index);
        }
        this.setSelectedItem(index == -1 ? null : this.dataModel.getElementAt(index));
    }

    public int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            if (this.dataModel instanceof DefaultComboBoxModel) {
                return ((DefaultComboBoxModel)this.dataModel).getIndexOf(selectedItem);
            }
            int size = this.dataModel.getSize();
            int i = 0;
            while (i < size) {
                Object o = this.dataModel.getElementAt(i);
                if (selectedItem != null ? selectedItem.equals(o) : o == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(Object value) {
        Object oldValue = this.prototypeDisplayValue;
        this.prototypeDisplayValue = value;
        this.firePropertyChange("prototypeDisplayValue", oldValue, value);
    }

    public void addItem(Object element) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to add the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).addElement(element);
    }

    public void insertItemAt(Object element, int index) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to insert the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).insertElementAt(element, index);
    }

    public void removeItem(Object element) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElement(element);
    }

    public void removeItemAt(int index) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElementAt(index);
    }

    public void removeAllItems() {
        if (this.dataModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.dataModel).removeAllElements();
        } else if (this.dataModel instanceof MutableComboBoxModel) {
            MutableComboBoxModel mcbm = (MutableComboBoxModel)this.dataModel;
            int i = mcbm.getSize() - 1;
            while (i >= 0) {
                mcbm.removeElementAt(i);
                --i;
            }
        } else {
            throw new RuntimeException("Unable to remove the items because the data model it is not an instance of MutableComboBoxModel.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean visible) {
        this.getUI().setPopupVisible(this, visible);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action a) {
        Action old = this.action;
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.addActionListener(this.action);
        }
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                JComboBox.this.configurePropertiesFromAction(act);
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent e) {
        ItemListener[] ll = this.getItemListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].itemStateChanged(e);
            ++i;
        }
    }

    protected void fireActionEvent() {
        ActionListener[] ll = this.getActionListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            ++i;
        }
    }

    public void firePopupMenuCanceled() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuCanceled(e);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuWillBecomeInvisible(e);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuWillBecomeVisible(e);
            ++i;
        }
    }

    protected void selectedItemChanged() {
        Object newSelection;
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        if ((newSelection = this.getSelectedItem()) != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, newSelection, 1));
        }
        this.fireActionEvent();
        this.selectedItemReminder = newSelection;
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    public void actionPerformed(ActionEvent e) {
        this.setSelectedItem(((ComboBoxEditor)e.getSource()).getItem());
        this.setPopupVisible(false);
    }

    public boolean selectWithKeyChar(char keyChar) {
        return false;
    }

    public void intervalAdded(ListDataEvent event) {
        this.repaint();
    }

    public void intervalRemoved(ListDataEvent event) {
        this.repaint();
    }

    public void contentsChanged(ListDataEvent event) {
        if (event.getIndex0() == -1 && event.getIndex1() == -1) {
            this.selectedItemChanged();
        }
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = super.isEnabled();
        if (enabled != oldEnabled) {
            super.setEnabled(enabled);
            this.firePropertyChange("enabled", oldEnabled, enabled);
        }
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.setPopupVisible(false);
        } else if (this.keySelectionManager != null) {
            int i = this.keySelectionManager.selectionForKey(e.getKeyChar(), this.getModel());
            if (i >= 0) {
                this.setSelectedIndex(i);
            } else {
                super.processKeyEvent(e);
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    public void setKeySelectionManager(KeySelectionManager aManager) {
        this.keySelectionManager = aManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return null;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int index) {
        return this.dataModel.getElementAt(index);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return null;
    }

    protected String paramString() {
        return "JComboBox";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    public void addActionListener(ActionListener listener) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JComboBox.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeActionListener(ActionListener listener) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JComboBox.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JComboBox.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])this.getListeners(clazz);
    }

    public void addItemListener(ItemListener listener) {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = JComboBox.class("[Ljava.awt.event.ItemListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeItemListener(ItemListener listener) {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = JComboBox.class("[Ljava.awt.event.ItemListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ItemListener[] getItemListeners() {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = JComboBox.class("[Ljava.awt.event.ItemListener;", false);
        }
        return (ItemListener[])this.getListeners(clazz);
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JComboBox.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JComboBox.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JComboBox.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        return (PopupMenuListener[])this.getListeners(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JComboBox(ComboBoxModel model) {
        this.setEditable(false);
        this.setEnabled(true);
        this.setMaximumRowCount(8);
        this.setModel(model);
        this.setActionCommand("comboBoxChanged");
        this.lightWeightPopupEnabled = true;
        this.isEditable = false;
        this.updateUI();
    }

    public JComboBox(Object[] itemArray) {
        this(new DefaultComboBoxModel(itemArray));
        if (itemArray.length > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox(Vector itemVector) {
        this(new DefaultComboBoxModel(itemVector));
        if (itemVector.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox() {
        this(new DefaultComboBoxModel());
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private static final long serialVersionUID = 8217828307256675666L;

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int value0) {
            return null;
        }

        public boolean isAccessibleChildSelected(int value0) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public String getAccessibleActionDescription(int value0) {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public boolean doAccessibleAction(int value0) {
            return false;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int value0) {
        }

        public void removeAccessibleSelection(int value0) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }

        protected AccessibleJComboBox() {
        }
    }
}

