/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TransferHandler
implements Serializable {
    private static final long serialVersionUID = -967749805571669910L;
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_CUT = "cut";
    private static final String COMMAND_PASTE = "paste";
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static Action copyAction = new TransferAction("copy");
    private static Action cutAction = new TransferAction("cut");
    private static Action pasteAction = new TransferAction("paste");
    static Clipboard clipboard;
    private int sourceActions;
    private Icon visualRepresentation;

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        return null;
    }

    public void exportAsDrag(JComponent c, InputEvent e, int action) {
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public void exportToClipboard(JComponent c, Clipboard clip, int action) {
    }

    public int getSourceActions(JComponent c) {
        return this.sourceActions;
    }

    public Icon getVisualRepresentation(Transferable t) {
        return this.visualRepresentation;
    }

    public boolean importData(JComponent c, Transferable t) {
        return false;
    }

    static /* synthetic */ String access$0() {
        return COMMAND_COPY;
    }

    static /* synthetic */ String access$1() {
        return COMMAND_CUT;
    }

    static /* synthetic */ String access$2() {
        return COMMAND_PASTE;
    }

    protected TransferHandler() {
        this.sourceActions = 0;
    }

    public TransferHandler(String property) {
        int n = 0;
        if (property != null) {
            n = 1;
        }
        this.sourceActions = n;
    }

    static class TransferAction
    extends AbstractAction {
        private String command;

        public void actionPerformed(ActionEvent event) {
            Transferable transferable;
            JComponent component = (JComponent)event.getSource();
            TransferHandler transferHandler = component.getTransferHandler();
            Clipboard clipboard = TransferAction.getClipboard(component);
            if (this.command.equals(TransferHandler.COMMAND_COPY)) {
                transferHandler.exportToClipboard(component, clipboard, 1);
            } else if (this.command.equals(TransferHandler.COMMAND_CUT)) {
                transferHandler.exportToClipboard(component, clipboard, 2);
            } else if (this.command.equals(TransferHandler.COMMAND_PASTE) && (transferable = clipboard.getContents(null)) != null) {
                transferHandler.importData(component, transferable);
            }
        }

        private static final Clipboard getClipboard(JComponent component) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkSystemClipboardAccess();
                    return component.getToolkit().getSystemClipboard();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (clipboard == null) {
                clipboard = new Clipboard("Clipboard");
            }
            return clipboard;
        }

        public TransferAction(String command) {
            this.command = command;
        }
    }
}

