/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    public static ComponentUI createUI(JComponent component) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (tabPlacement == 1) {
            this.paintTopTabBorder(tabIndex, g, x, y, w, h, 0, 0, isSelected);
        } else if (tabPlacement == 2) {
            this.paintLeftTabBorder(tabIndex, g, x, y, w, h, 0, 0, isSelected);
        } else if (tabPlacement == 3) {
            this.paintBottomTabBorder(tabIndex, g, x, y, w, h, 0, 0, isSelected);
        } else if (tabPlacement == 4) {
            this.paintRightTabBorder(tabIndex, g, x, y, w, h, 0, 0, isSelected);
        } else {
            throw new AssertionError((Object)"Unrecognised 'tabPlacement' argument.");
        }
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 1, y + h, x + 1, y + 6);
            g.drawLine(x + 1, y + 6, x + 6, y + 1);
            g.drawLine(x + 6, y + 1, x + w - 1, y + 1);
        }
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawLine(x, y + h - 1, x, y + 6);
        g.drawLine(x, y + 6, x + 6, y);
        g.drawLine(x + 6, y, x + w, y);
        g.drawLine(x + w, y, x + w, y + h - 1);
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 1, y + h, x + 1, y + 6);
            g.drawLine(x + 1, y + 6, x + 6, y + 1);
            g.drawLine(x + 6, y + 1, x + w - 1, y + 1);
        }
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawLine(x, y + h, x, y + 6);
        g.drawLine(x, y + 6, x + 6, y);
        g.drawLine(x + 6, y, x + w - 1, y);
        g.drawLine(x, y + h, x + w - 1, y + h);
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x, y + 1, x + w - 7, y + 1);
            g.drawLine(x + w - 7, y + 1, x + w - 1, y + 7);
        }
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawLine(x, y, x + w - 7, y);
        g.drawLine(x + w - 7, y, x + w - 1, y + 6);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y + h, x, y + h);
    }

    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 1, y, x + 1, y + h - 7);
            g.drawLine(x + 1, y + h - 7, x + 7, y + h - 1);
        }
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawLine(x, y, x, y + h - 7);
        g.drawLine(x, y + h - 7, x + 6, y + h - 1);
        g.drawLine(x + 6, y + h - 1, x + w, y + h - 1);
        g.drawLine(x + w, y + h - 1, x + w, y);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int[] py;
        int[] px;
        if (isSelected) {
            g.setColor(MetalLookAndFeel.getControl());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        if (tabPlacement == 1) {
            px = new int[]{x + 6, x + w - 1, x + w - 1, x + 2, x + 2};
            py = new int[]{y + 2, y + 2, y + h - 1, y + h - 1, y + 6};
        } else if (tabPlacement == 2) {
            px = new int[]{x + 6, x + w - 1, x + w - 1, x + 2, x + 2};
            py = new int[]{y + 2, y + 2, y + h - 1, y + h - 1, y + 6};
        } else if (tabPlacement == 3) {
            px = new int[]{x + 2, x + w - 1, x + w - 1, x + 8, x + 2};
            py = new int[]{y, y, y + h - 1, y + h - 1, y + h - 7};
        } else if (tabPlacement == 4) {
            px = new int[]{x + 2, x + w - 7, x + w - 1, x + w - 1, x + 2};
            py = new int[]{y + 2, y + 2, y + 7, y + h - 1, y + h - 1};
        } else {
            throw new AssertionError((Object)"Unrecognised 'tabPlacement' argument.");
        }
        g.fillPolygon(px, py, 5);
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        boolean bl = false;
        if (run < this.runCount - 1) {
            bl = true;
        }
        return bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }
}

