/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.Segment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PasswordView
extends FieldView {
    private char[] oneCharBuffer;

    protected int drawEchoCharacter(Graphics g, int x, int y, char ch) {
        this.updateMetrics();
        this.oneCharBuffer[0] = ch;
        g.drawChars(this.oneCharBuffer, 0, 1, x, y);
        return x + this.metrics.charWidth(ch);
    }

    private final char getEchoChar() {
        char ch = ((JPasswordField)this.getContainer()).getEchoChar();
        if (ch == '\u0000') {
            ch = '*';
        }
        return (char)ch;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.updateMetrics();
        char ch = this.getEchoChar();
        g.setColor(this.selectedColor);
        g.setColor(Color.BLACK);
        int len = p1 - p0;
        char[] buffer = new char[len];
        int index = 0;
        while (index < len) {
            buffer[index] = ch;
            ++index;
        }
        g.drawChars(buffer, 0, len, x, y);
        return x + len * this.metrics.charWidth(ch);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.updateMetrics();
        char ch = this.getEchoChar();
        Segment segment = new Segment();
        g.setColor(this.unselectedColor);
        g.setColor(Color.BLACK);
        this.getDocument().getText(p0, --p1 - p0, segment);
        int len = segment.toString().length();
        char[] buffer = new char[len];
        int index = 0;
        while (index < len) {
            buffer[index] = ch;
            ++index;
        }
        y = (int)((float)y + this.getPreferredSpan(1) / 2.0f);
        g.drawChars(buffer, 0, len, x, y);
        return x + len * this.metrics.charWidth(ch);
    }

    public float getPreferredSpan(int axis) {
        String text;
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fm = this.getFontMetrics();
        if (axis == 1) {
            return fm.getHeight();
        }
        Element elem = this.getElement();
        try {
            text = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset());
        }
        catch (BadLocationException e) {
            text = "";
        }
        return fm.stringWidth(text);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return super.modelToView(pos, a, b);
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        return super.viewToModel(fx, fy, a, bias);
    }

    private final /* synthetic */ void this() {
        this.oneCharBuffer = new char[1];
    }

    public PasswordView(Element elem) {
        super(elem);
        this.this();
    }
}

