/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static final long serialVersionUID = 8042858831190784241L;
    public static final String DEFAULT_STYLE = "default";
    static Hashtable sharedAttributeSets = new Hashtable();
    static Hashtable sharedFonts = new Hashtable();
    static StyleContext defaultStyleContext = new StyleContext();
    static final int compressionThreshold = 9;
    NamedStyle defaultStyle;
    EventListenerList listenerList;
    Hashtable styleTable;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet a) {
        return new SmallAttributeSet(a);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet a) {
        return new SimpleAttributeSet(a);
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public Style addStyle(String name, Style parent) {
        NamedStyle newStyle = new NamedStyle(name, parent);
        if (name != null) {
            this.styleTable.put(name, newStyle);
        }
        return newStyle;
    }

    public void removeStyle(String name) {
        this.styleTable.remove(name);
    }

    public Style getStyle(String name) {
        return (Style)this.styleTable.get(name);
    }

    public Enumeration getStyleNames() {
        return this.styleTable.keys();
    }

    public Font getFont(AttributeSet attr) {
        String family = StyleConstants.getFontFamily(attr);
        int style = 0;
        if (StyleConstants.isBold(attr)) {
            ++style;
        }
        if (StyleConstants.isItalic(attr)) {
            style += 2;
        }
        int size = StyleConstants.getFontSize(attr);
        return this.getFont(family, style, size);
    }

    public Font getFont(String family, int style, int size) {
        SimpleFontSpec spec = new SimpleFontSpec(family, style, size);
        if (sharedFonts.containsKey(spec)) {
            return (Font)sharedFonts.get(spec);
        }
        Font tmp = new Font(family, style, size);
        sharedFonts.put(spec, tmp);
        return tmp;
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public Color getForeground(AttributeSet a) {
        return StyleConstants.getForeground(a);
    }

    public Color getBackground(AttributeSet a) {
        return StyleConstants.getBackground(a);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        return defaultStyleContext;
    }

    public AttributeSet addAttribute(AttributeSet old, Object name, Object value) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).addAttribute(name, value);
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.addAttribute(name, value);
        if (mutable.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutable;
        }
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet addAttributes(AttributeSet old, AttributeSet attributes) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).addAttributes(attributes);
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.addAttributes(attributes);
        if (mutable.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutable;
        }
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet getEmptySet() {
        AttributeSet e = this.createSmallAttributeSet(null);
        if (sharedAttributeSets.containsKey(e)) {
            e = (AttributeSet)sharedAttributeSets.get(e);
        } else {
            sharedAttributeSets.put(e, e);
        }
        return e;
    }

    public void reclaim(AttributeSet attributes) {
        if (sharedAttributeSets.containsKey(attributes)) {
            sharedAttributeSets.remove(attributes);
        }
    }

    public AttributeSet removeAttribute(AttributeSet old, Object name) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).removeAttribute(name);
            if (old.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet small = this.createSmallAttributeSet(old);
                if (!sharedAttributeSets.containsKey(small)) {
                    sharedAttributeSets.put(small, small);
                }
                old = (AttributeSet)sharedAttributeSets.get(small);
            }
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.removeAttribute(name);
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet removeAttributes(AttributeSet old, AttributeSet attributes) {
        return this.removeAttributes(old, attributes.getAttributeNames());
    }

    public AttributeSet removeAttributes(AttributeSet old, Enumeration names) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).removeAttributes(names);
            if (old.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet small = this.createSmallAttributeSet(old);
                if (!sharedAttributeSets.containsKey(small)) {
                    sharedAttributeSets.put(small, small);
                }
                old = (AttributeSet)sharedAttributeSets.get(small);
            }
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.removeAttributes(names);
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public static Object getStaticAttribute(Object key) {
        throw new InternalError("not implemented");
    }

    public static Object getStaticAttributeKey(Object key) {
        throw new InternalError("not implemented");
    }

    public static void readAttributeSet(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public static void writeAttributeSet(ObjectOutputStream out, AttributeSet a) throws IOException {
        throw new InternalError("not implemented");
    }

    public void readAttributes(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public void writeAttributes(ObjectOutputStream out, AttributeSet a) throws IOException {
        throw new InternalError("not implemented");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.defaultStyle = new NamedStyle(DEFAULT_STYLE, null);
    }

    public StyleContext() {
        this.this();
        this.listenerList = new EventListenerList();
        this.styleTable = new Hashtable();
        this.styleTable.put(DEFAULT_STYLE, this.defaultStyle);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SmallAttributeSet
    implements AttributeSet {
        final Object[] attrs;

        public Object clone() {
            return new SmallAttributeSet(this.attrs);
        }

        public boolean containsAttribute(Object name, Object value) {
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i].equals(name) && this.attrs[i + 1].equals(value)) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean containsAttributes(AttributeSet a) {
            Enumeration e = a.getAttributeNames();
            while (e.hasMoreElements()) {
                Object val;
                Object name = e.nextElement();
                if (this.containsAttribute(name, val = a.getAttribute(name))) continue;
                return false;
            }
            return true;
        }

        public AttributeSet copyAttributes() {
            return (AttributeSet)this.clone();
        }

        public boolean equals(Object obj) {
            boolean bl = false;
            if (obj instanceof AttributeSet && this.isEqual((AttributeSet)obj)) {
                bl = true;
            }
            return bl;
        }

        public Object getAttribute(Object key) {
            AttributeSet p;
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i].equals(key)) {
                    return this.attrs[i + 1];
                }
                i += 2;
            }
            if (!key.equals(ResolveAttribute) && (p = this.getResolveParent()) != null && p instanceof AttributeSet) {
                return p.getAttribute(key);
            }
            return null;
        }

        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        public Enumeration getAttributeNames() {
            return new Enumeration(){
                int i;

                public final boolean hasMoreElements() {
                    boolean bl = false;
                    if (this.i < SmallAttributeSet.this.attrs.length) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object nextElement() {
                    this.i += 2;
                    return SmallAttributeSet.this.attrs[this.i - 2];
                }

                private final /* synthetic */ void this() {
                    this.i = 0;
                }
                {
                    this.this();
                }
            };
        }

        public AttributeSet getResolveParent() {
            return (AttributeSet)this.getAttribute(ResolveAttribute);
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        public boolean isDefined(Object key) {
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i].equals(key)) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attr) {
            boolean bl = false;
            if (attr != null && attr.containsAttributes(this) && this.containsAttributes(attr)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[StyleContext.SmallattributeSet:");
            int i = 0;
            while (i < this.attrs.length) {
                sb.append(" (");
                sb.append(this.attrs[i].toString());
                sb.append("=");
                sb.append(this.attrs[i + 1].toString());
                sb.append(")");
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }

        public SmallAttributeSet(AttributeSet a) {
            if (a == null) {
                this.attrs = new Object[0];
            } else {
                int n = a.getAttributeCount();
                int i = 0;
                this.attrs = new Object[n * 2];
                Enumeration e = a.getAttributeNames();
                while (e.hasMoreElements()) {
                    Object name = e.nextElement();
                    this.attrs[i++] = name;
                    this.attrs[i++] = a.getAttribute(name);
                }
            }
        }

        public SmallAttributeSet(Object[] a) {
            if (a == null) {
                this.attrs = new Object[0];
            } else {
                this.attrs = new Object[a.length];
                System.arraycopy(a, 0, this.attrs, 0, a.length);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NamedStyle
    implements Serializable,
    Style {
        private static final long serialVersionUID = -6690628971806226374L;
        protected ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        AttributeSet attributes;
        String name;

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
            this.fireStateChanged();
        }

        public void addChangeListener(ChangeListener l) {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            this.listenerList.add(clazz, l);
        }

        public void removeChangeListener(ChangeListener l) {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            this.listenerList.remove(clazz, l);
        }

        public EventListener[] getListeners(Class listenerType) {
            return this.listenerList.getListeners(listenerType);
        }

        public ChangeListener[] getChangeListeners() {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            return (ChangeListener[])this.getListeners(clazz);
        }

        protected void fireStateChanged() {
            ChangeListener[] listeners = this.getChangeListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].stateChanged(this.changeEvent);
                ++i;
            }
        }

        public void addAttribute(Object name, Object value) {
            this.attributes = StyleContext.this.addAttribute(this.attributes, name, value);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attr) {
            this.attributes = StyleContext.this.addAttributes(this.attributes, attr);
            this.fireStateChanged();
        }

        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object attrName) {
            return this.attributes.getAttribute(attrName);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        public boolean isEqual(AttributeSet attr) {
            return this.attributes.isEqual(attr);
        }

        public void removeAttribute(Object name) {
            this.attributes = StyleContext.this.removeAttribute(this.attributes, name);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attrs) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, attrs);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration names) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, names);
            this.fireStateChanged();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void setResolveParent(AttributeSet parent) {
            if (parent != null) {
                this.attributes = StyleContext.this.addAttribute(this.attributes, ResolveAttribute, parent);
            }
            this.fireStateChanged();
        }

        public String toString() {
            return "[NamedStyle: name=" + this.name + ", attrs=" + this.attributes.toString() + ']';
        }

        public NamedStyle() {
            this(null, null);
        }

        public NamedStyle(Style parent) {
            this(null, parent);
        }

        public NamedStyle(String name, Style parent) {
            this.name = name;
            this.attributes = StyleContext.this.getEmptySet();
            this.changeEvent = new ChangeEvent(this);
            this.listenerList = new EventListenerList();
            this.setResolveParent(parent);
        }
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public boolean equals(Object obj) {
            boolean bl = false;
            if (obj != null && obj instanceof SimpleFontSpec && ((SimpleFontSpec)obj).family.equals(this.family) && ((SimpleFontSpec)obj).style == this.style && ((SimpleFontSpec)obj).size == this.size) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }

        public SimpleFontSpec(String family, int style, int size) {
            this.family = family;
            this.style = style;
            this.size = size;
        }
    }
}

