/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.TrapExit;
import sbt.util.InterfaceUtil$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;

public final class TrapExit$ {
    public static TrapExit$ MODULE$;

    static {
        new TrapExit$();
    }

    public int apply(Function0<BoxedUnit> execute, Logger log) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof TrapExit) {
            TrapExit trapExit = (TrapExit)securityManager;
            n = trapExit.runManaged(InterfaceUtil$.MODULE$.toSupplier(execute), (xsbti.Logger)log);
        } else {
            n = this.runUnmanaged(execute, log);
        }
        return n;
    }

    public SecurityManager installManager() {
        SecurityManager securityManager;
        SecurityManager securityManager2 = System.getSecurityManager();
        if (securityManager2 instanceof TrapExit) {
            TrapExit trapExit;
            securityManager = trapExit = (TrapExit)securityManager2;
        } else {
            System.setSecurityManager(new TrapExit(securityManager2));
            securityManager = securityManager2;
        }
        return securityManager;
    }

    public void uninstallManager(SecurityManager previous) {
        System.setSecurityManager(previous);
    }

    private int runUnmanaged(Function0<BoxedUnit> execute, Logger log) {
        int n;
        log.warn((Function0 & java.io.Serializable & Serializable)() -> "Managed execution not possible: security manager not installed.");
        try {
            execute.apply$mcV$sp();
            n = 0;
        }
        catch (Exception e) {
            log.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("Error during execution: ").append(e.toString()).toString());
            log.trace((Function0 & java.io.Serializable & Serializable)() -> e);
            n = 1;
        }
        return n;
    }

    public boolean sbt$TrapExit$$isDone(Thread t) {
        Thread.State state = t.getState();
        Thread.State state2 = Thread.State.TERMINATED;
        return !(state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null);
    }

    public String sbt$TrapExit$$computeID(ThreadGroup g) {
        return new StringBuilder(3).append("g:").append(Integer.toHexString(System.identityHashCode(g))).append(":").append(g.getName()).toString();
    }

    public String sbt$TrapExit$$computeID(Thread t) {
        return String.valueOf(Integer.toHexString(System.identityHashCode(t)));
    }

    public void sbt$TrapExit$$waitOnThread(Thread thread, Logger log) {
        log.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Waiting for thread ").append(thread.getName()).append(" to terminate.").toString());
        thread.join();
        log.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(16).append("\tThread ").append(thread.getName()).append(" exited.").toString());
    }

    public void sbt$TrapExit$$safeInterrupt(Thread thread, Logger log) {
        log.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Interrupting thread ").append(thread.getName()).toString());
        thread.setUncaughtExceptionHandler(new TrapExit.TrapInterrupt(thread.getUncaughtExceptionHandler()));
        thread.interrupt();
        log.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(13).append("\tInterrupted ").append(thread.getName()).toString());
    }

    public <CauseType extends Throwable, T> T sbt$TrapExit$$withCause(Throwable e, Function1<CauseType, T> withType, Function1<Throwable, T> notType, Manifest<CauseType> mf) {
        Object object;
        while (true) {
            Class clazz;
            if ((clazz = mf.runtimeClass()).isInstance(e)) {
                object = withType.apply((Object)e);
                break;
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                object = notType.apply((Object)e);
                break;
            }
            e = cause;
        }
        return (T)object;
    }

    private TrapExit$() {
        MODULE$ = this;
    }
}

