/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class AntCallTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyonce = true;
    private String target = null;
    private Collection calls = new ArrayList();
    private String prefix;

    @Override
    public void progress(IvyEvent ivyEvent) {
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        if (project == null) {
            Message.info("ant call trigger can only be used from an ant build. Ignoring.");
            return;
        }
        if (this.onlyonce && this.isTriggered(ivyEvent)) {
            Message.verbose("call already triggered for this event, skipping: " + ivyEvent);
        } else {
            CallTarget callTarget = new CallTarget();
            callTarget.setProject(project);
            callTarget.setTaskName("antcall");
            Map map = ivyEvent.getAttributes();
            String string = IvyPatternHelper.substituteTokens(this.getTarget(), map);
            callTarget.setTarget(string);
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                Property property = callTarget.createParam();
                property.setName(this.prefix == null ? string2 : this.prefix + string2);
                property.setValue(string3 == null ? "" : string3);
            }
            Message.verbose("triggering ant call: target=" + string + " for " + ivyEvent);
            callTarget.execute();
            this.markTriggered(ivyEvent);
            Message.debug("triggered ant call finished: target=" + string + " for " + ivyEvent);
        }
    }

    private void markTriggered(IvyEvent ivyEvent) {
        this.calls.add(ivyEvent);
    }

    private boolean isTriggered(IvyEvent ivyEvent) {
        return this.calls.contains(ivyEvent);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public boolean isOnlyonce() {
        return this.onlyonce;
    }

    public void setOnlyonce(boolean bl) {
        this.onlyonce = bl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
        if (!string.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

