/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CachedVector<E>
extends Vector<E> {
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> c) {
        super(c);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public int indexOf(Object elem) {
        this.initializeCache();
        Integer o = this._indexCache.get(elem);
        if (o != null) {
            return o;
        }
        if (this.isLazyCaching()) {
            int i = super.indexOf(elem);
            if (i == -1) {
                this.uncacheIt(elem);
            } else {
                this.cacheIt(elem, i);
            }
            return i;
        }
        return -1;
    }

    protected synchronized void adjustCache(int index, int increase) {
        if (this._indexCache != null) {
            Map<Object, Integer> newCache = this.createCache();
            Set<Object> keys = this._indexCache.keySet();
            for (Object key : keys) {
                int value = this._indexCache.get(key);
                if (value >= index) {
                    newCache.put(key, value + increase);
                    continue;
                }
                newCache.put(key, value);
            }
            this._indexCache = newCache;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public synchronized void cacheIt(Object o, int index) {
        if (this._indexCache != null && (this._indexCache.get(o) == null || index < this._indexCache.get(o))) {
            this._indexCache.put(o, index);
        }
    }

    public synchronized void uncacheIt(Object o) {
        if (this._indexCache != null) {
            this._indexCache.remove(o);
        }
    }

    @Override
    public boolean add(E element) {
        boolean added = super.add(element);
        if (!this.isLazyCaching() && added) {
            this.initializeCache();
            this.cacheIt(element, this.size() - 1);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        } else if (this._indexCache != null) {
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int index) {
        Object element = super.remove(index);
        if (element != null) {
            this.uncacheIt(element);
            this.adjustCache(index, -1);
        }
        return element;
    }

    @Override
    public boolean remove(Object o) {
        int oldIndex = this.indexOf(o);
        boolean removed = super.remove(o);
        if (removed) {
            this.uncacheIt(o);
            this.adjustCache(oldIndex, -1);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.uncacheAll();
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = super.addAll(c);
        if (added) {
            this.cacheAll();
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added = super.addAll(index, c);
        this.initializeCache();
        this.adjustCache(index, c.size());
        for (E e : c) {
            this.cacheIt(e, index++);
        }
        return added;
    }

    @Override
    public E set(int index, E element) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e = super.set(index, element);
            this.uncacheIt(e);
            this.cacheIt(element, index);
            return e;
        }
        return super.set(index, element);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer i = 0;
        for (Object elem : this) {
            if (this._indexCache.get(elem) == null) {
                this._indexCache.put(elem, i);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean lazyCaching) {
        this._lazyCaching = lazyCaching;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
        } else {
            super.removeRange(fromIndex, toIndex);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

