/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.BaseMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLTab
extends BaseMainPanelTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLTab.class);
    private SQLPanel _comp;

    public SQLTab(ISession session) {
        this.setSession(session);
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("SQLTab.hint");
    }

    @Override
    public synchronized Component getComponent() {
        if (this._comp == null) {
            this._comp = new SQLPanel(this.getSession(), true);
        }
        return this._comp;
    }

    @Override
    public void setSession(ISession session) {
        super.setSession(session);
        this.getSQLPanel().setSession(session);
    }

    @Override
    public synchronized void refreshComponent() {
    }

    @Override
    public void sessionClosing(ISession session) {
        if (this._comp != null) {
            this._comp.sessionClosing();
        }
    }

    @Override
    public synchronized void select() {
        super.select();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLTab.this._comp.getSQLEntryPanel().requestFocus();
            }
        });
    }

    public SQLPanel getSQLPanel() {
        return (SQLPanel)this.getComponent();
    }
}

