/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.FindInObjectTreeController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.IObjectTreeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTree;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeDndTransfer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeTabbedPane;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseDataSetTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.CatalogsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.ConnectionStatusTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.DataTypesTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.KeywordsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.MetaDataTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.NumericFunctionsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.SchemasTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.StringFunctionsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.SystemFunctionsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.TableTypesTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database.TimeDateFunctionsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.procedure.ProcedureColumnsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ColumnPriviligesTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ColumnsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ContentsTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ExportedKeysTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ImportedKeysTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.IndexesTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.PrimaryKeyTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.RowCountTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.RowIDTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.TablePriviligesTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.VersionColumnsTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoUpdateListener;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreePanel
extends JPanel
implements IObjectTreeAPI {
    private static final ILogger s_log = LoggerController.createLogger(ObjectTreePanel.class);
    private IIdentifier _id = IdentifierFactory.getInstance().createIdentifier();
    private transient ISession _session;
    private ObjectTree _tree;
    private final JSplitPane _splitPane = new JSplitPane(1);
    private final ObjectTreeTabbedPane _emptyTabPane;
    private final Map<IIdentifier, ObjectTreeTabbedPane> _tabbedPanes = new HashMap<IIdentifier, ObjectTreeTabbedPane>();
    private SessionPropertiesListener _propsListener;
    private TabbedPaneListener _tabPnlListener;
    private transient ObjectTreeSelectionListener _objTreeSelLis = null;
    private ObjectTreeTabbedPane _selectedObjTreeTabbedPane = null;
    private TreePath[] previouslySelectedPaths = null;
    private FindInObjectTreeController _findInObjectTreeController;

    public ObjectTreePanel(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this._emptyTabPane = new ObjectTreeTabbedPane(this._session);
        this._findInObjectTreeController = new FindInObjectTreeController(this._session);
        this.createGUI();
        this.init();
        this.initDnD();
    }

    private void initDnD() {
        this._tree.setTransferHandler(new TransferHandler("DragedTreeNode"){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new DataHandler((Object)new ObjectTreeDndTransfer(ObjectTreePanel.this.getSelectedTables(), ObjectTreePanel.this._session.getIdentifier()), "application/x-java-jvm-local-objectref");
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this._tree.setDragEnabled(true);
    }

    private void init() {
        try {
            SQLDatabaseMetaData md;
            this.addDetailTab(DatabaseObjectType.SESSION, new MetaDataTab());
            this.addDetailTab(DatabaseObjectType.SESSION, new ConnectionStatusTab());
            try {
                md = this._session.getSQLConnection().getSQLMetaData();
                if (md.supportsCatalogs()) {
                    this._addDetailTab(DatabaseObjectType.SESSION, new CatalogsTab());
                }
            }
            catch (Throwable th) {
                s_log.error("Error in supportsCatalogs()", th);
            }
            try {
                md = this._session.getSQLConnection().getSQLMetaData();
                if (md.supportsSchemas()) {
                    this._addDetailTab(DatabaseObjectType.SESSION, new SchemasTab());
                }
            }
            catch (Throwable th) {
                s_log.error("Error in supportsCatalogs()", th);
            }
            this._addDetailTab(DatabaseObjectType.SESSION, new TableTypesTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new DataTypesTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new NumericFunctionsTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new StringFunctionsTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new SystemFunctionsTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new TimeDateFunctionsTab());
            this._addDetailTab(DatabaseObjectType.SESSION, new KeywordsTab());
            this._addDetailTab(DatabaseObjectType.CATALOG, new DatabaseObjectInfoTab());
            this._addDetailTab(DatabaseObjectType.SCHEMA, new DatabaseObjectInfoTab());
            this._addDetailTabForTableLikeObjects(DatabaseObjectType.TABLE);
            this._addDetailTabForTableLikeObjects(DatabaseObjectType.VIEW);
            this._addDetailTab(DatabaseObjectType.PROCEDURE, new DatabaseObjectInfoTab());
            this._addDetailTab(DatabaseObjectType.PROCEDURE, new ProcedureColumnsTab());
            this._addDetailTab(DatabaseObjectType.UDT, new DatabaseObjectInfoTab());
            this._session.getSchemaInfo().addSchemaInfoUpdateListener(new SchemaInfoUpdateListener(){

                @Override
                public void schemaInfoUpdated() {
                    ObjectTreePanel.this.refreshTree(false);
                }
            });
        }
        catch (Throwable th) {
            s_log.error("Error doing background initalization of Object tree", th);
        }
    }

    private void _addDetailTabForTableLikeObjects(final DatabaseObjectType type) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ObjectTreePanel.this.addDetailTabForTableLikeObjects(type);
            }
        });
    }

    private void addDetailTabForTableLikeObjects(DatabaseObjectType type) {
        this.addDetailTab(type, new DatabaseObjectInfoTab());
        ContentsTab conttentsTab = new ContentsTab(this);
        conttentsTab.addListener(new DataSetUpdateableTableModelListener(){

            @Override
            public void forceEditMode(boolean mode) {
                ObjectTreePanel.this.onForceEditMode(mode);
            }
        });
        this.addDetailTab(type, conttentsTab);
        this.addDetailTab(type, new RowCountTab());
        this.addDetailTab(type, new ColumnsTab());
        this.addDetailTab(type, new PrimaryKeyTab());
        this.addDetailTab(type, new ExportedKeysTab());
        this.addDetailTab(type, new ImportedKeysTab());
        this.addDetailTab(type, new IndexesTab());
        this.addDetailTab(type, new TablePriviligesTab());
        this.addDetailTab(type, new ColumnPriviligesTab());
        this.addDetailTab(type, new RowIDTab());
        this.addDetailTab(type, new VersionColumnsTab());
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._tabPnlListener = new TabbedPaneListener();
        this._propsListener = new SessionPropertiesListener();
        this._session.getProperties().addPropertyChangeListener(this._propsListener);
        for (ObjectTreeTabbedPane ottp : this._tabbedPanes.values()) {
            ottp.getTabbedPane().addChangeListener(this._tabPnlListener);
        }
        this._objTreeSelLis = new ObjectTreeSelectionListener();
        this._tree.addTreeSelectionListener(this._objTreeSelLis);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
        for (ObjectTreeTabbedPane pane : this._tabbedPanes.values()) {
            pane.getTabbedPane().removeChangeListener(this._tabPnlListener);
        }
        this._tabPnlListener = null;
        if (this._objTreeSelLis != null) {
            this._tree.removeTreeSelectionListener(this._objTreeSelLis);
            this._objTreeSelLis = null;
        }
    }

    @Override
    public void addExpander(DatabaseObjectType dboType, INodeExpander expander) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (expander == null) {
            throw new IllegalArgumentException("Null INodeExpander passed");
        }
        this._tree.getTypedModel().addExpander(dboType, expander);
    }

    @Override
    public void expandNode(ObjectTreeNode node) {
        IDatabaseObjectInfo info = node.getDatabaseObjectInfo();
        TreePath path = this.getTreePath(info.getCatalogName(), info.getSchemaName(), new FilterMatcher(info.getSimpleName(), null));
        this._tree.fireTreeExpanded(path);
    }

    private void _addDetailTab(final DatabaseObjectType dboType, final IObjectTab tab) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ObjectTreePanel.this.addDetailTab(dboType, tab);
            }
        });
    }

    @Override
    public void addDetailTab(DatabaseObjectType dboType, IObjectTab tab) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (tab == null) {
            throw new IllegalArgumentException("IObjectPanelTab == null");
        }
        this.getOrCreateObjectPanelTabbedPane(dboType).addObjectPanelTab(tab);
    }

    @Override
    public void addTreeModelListener(TreeModelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("TreeModelListener == null");
        }
        this._tree.getModel().addTreeModelListener(lis);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("TreeModelListener == null");
        }
        this._tree.getModel().removeTreeModelListener(lis);
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("TreeSelectionListener == null");
        }
        this._tree.addTreeSelectionListener(lis);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("TreeSelectionListener == null");
        }
        this._tree.removeTreeSelectionListener(lis);
    }

    @Override
    public void addObjectTreeListener(IObjectTreeListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("IObjectTreeListener == null");
        }
        this._tree.addObjectTreeListener(lis);
    }

    @Override
    public void removeObjectTreeListener(IObjectTreeListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("IObjectTreeListener == null");
        }
        this._tree.removeObjectTreeListener(lis);
    }

    @Override
    public void addToPopup(DatabaseObjectType dboType, Action action) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        this._tree.addToPopup(dboType, action);
    }

    @Override
    public void addToPopup(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        this._tree.addToPopup(action);
    }

    @Override
    public void addToPopup(DatabaseObjectType dboType, JMenu menu) {
        if (dboType == null) {
            throw new IllegalArgumentException("DatabaseObjectType == null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        this._tree.addToPopup(dboType, menu);
    }

    @Override
    public void addToPopup(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        this._tree.addToPopup(menu);
    }

    @Override
    public ISession getSession() {
        return this._session;
    }

    @Override
    public ObjectTreeNode[] getSelectedNodes() {
        return this._tree.getSelectedNodes();
    }

    @Override
    public List<ITableInfo> getSelectedTables() {
        return this._tree.getSelectedTables();
    }

    public void saveSelectedPaths() {
        this.previouslySelectedPaths = this._tree.getSelectionPaths();
    }

    public void restoreSavedSelectedPaths() {
        this._tree.setSelectionPaths(this.previouslySelectedPaths);
        this._tree.requestFocusInWindow();
    }

    @Override
    public IDatabaseObjectInfo[] getSelectedDatabaseObjects() {
        return this._tree.getSelectedDatabaseObjects();
    }

    @Override
    public DatabaseObjectType[] getDatabaseObjectTypes() {
        return this._tree.getTypedModel().getDatabaseObjectTypes();
    }

    @Override
    public void refreshTree() {
        this.refreshTree(false);
    }

    @Override
    public void refreshTree(boolean reloadSchemaInfo) {
        this._tree.refresh(reloadSchemaInfo);
    }

    @Override
    public void refreshSelectedNodes() {
        this._tree.refreshSelectedNodes();
    }

    @Override
    public void removeNodes(ObjectTreeNode[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("ObjectTreeNode[] == null");
        }
        ObjectTreeModel model = this._tree.getTypedModel();
        for (int i = 0; i < nodes.length; ++i) {
            model.removeNodeFromParent(nodes[i]);
        }
    }

    @Override
    public IObjectTab getTabbedPaneIfSelected(DatabaseObjectType dbObjectType, String title) {
        return this.getTabbedPane(dbObjectType).getTabIfSelected(title);
    }

    @Override
    public void refreshSelectedTab() throws DataSetException {
        IObjectTab tab;
        if (this._selectedObjTreeTabbedPane != null && (tab = this._selectedObjTreeTabbedPane.getSelectedTab()) != null && tab instanceof BaseDataSetTab) {
            BaseDataSetTab btab = (BaseDataSetTab)tab;
            btab.refreshComponent();
        }
    }

    @Override
    public boolean selectInObjectTree(String catalog, String schema, FilterMatcher objectMatcher) {
        if ("".equals(objectMatcher.getMetaDataMatchString())) {
            return false;
        }
        TreePath treePath = this.getTreePath(catalog, schema, objectMatcher);
        if (null != treePath) {
            this._tree.setSelectionPath(treePath);
            this._tree.scrollPathToVisible(treePath);
            return true;
        }
        return false;
    }

    private TreePath getTreePath(String catalog, String schema, FilterMatcher objectMatcher) {
        ObjectTreeModel otm = (ObjectTreeModel)this._tree.getModel();
        TreePath treePath = otm.getPathToDbInfo(catalog, schema, objectMatcher, (ObjectTreeNode)otm.getRoot(), false);
        if (null == treePath) {
            treePath = otm.getPathToDbInfo(catalog, schema, objectMatcher, (ObjectTreeNode)otm.getRoot(), true);
        }
        return treePath;
    }

    @Override
    public void addKnownDatabaseObjectType(DatabaseObjectType dboType) {
        this._tree.getTypedModel().addKnownDatabaseObjectType(dboType);
    }

    private void setSelectedObjectPanel(final TreePath path) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                Object lastComp;
                ObjectTreeTabbedPane tabPane = null;
                if (path != null && (lastComp = path.getLastPathComponent()) instanceof ObjectTreeNode) {
                    ObjectTreeNode node = (ObjectTreeNode)lastComp;
                    tabPane = ObjectTreePanel.this.getDetailPanel(node);
                    tabPane.setDatabaseObjectInfo(node.getDatabaseObjectInfo());
                    tabPane.selectCurrentTab();
                }
                ObjectTreePanel.this.setSelectedObjectPanel(tabPane);
            }
        });
    }

    private void setSelectedObjectPanel(ObjectTreeTabbedPane pane) {
        this._selectedObjTreeTabbedPane = pane;
        JTabbedPane comp = null;
        if (pane != null) {
            comp = pane.getTabbedPane();
        }
        if (comp == null) {
            comp = this._emptyTabPane.getTabbedPane();
        }
        int divLoc = this._splitPane.getDividerLocation();
        Component existing = this._splitPane.getRightComponent();
        if (existing != null) {
            this._splitPane.remove(existing);
        }
        this._splitPane.add((Component)comp, "right");
        this._splitPane.setDividerLocation(divLoc);
        if (pane != null) {
            pane.selectCurrentTab();
        }
    }

    private ObjectTreeTabbedPane getDetailPanel(ObjectTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("ObjectTreeNode == null");
        }
        ObjectTreeTabbedPane tabPane = this.getTabbedPane(node.getDatabaseObjectType());
        if (tabPane != null) {
            return tabPane;
        }
        return this._emptyTabPane;
    }

    private ObjectTreeTabbedPane getTabbedPane(DatabaseObjectType dboType) {
        return this._tabbedPanes.get(dboType.getIdentifier());
    }

    private ObjectTreeTabbedPane getOrCreateObjectPanelTabbedPane(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        IIdentifier key = dboType.getIdentifier();
        ObjectTreeTabbedPane tabPane = this._tabbedPanes.get(key);
        if (tabPane == null) {
            tabPane = new ObjectTreeTabbedPane(this._session);
            this.setupTabbedPane(tabPane);
            this._tabbedPanes.put(key, tabPane);
        }
        return tabPane;
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this._tree = new ObjectTree(this._session);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setContinuousLayout(true);
        LeftPanel leftPanel = new LeftPanel();
        leftPanel.setMinimumSize(new Dimension(50, 50));
        this._splitPane.add((Component)leftPanel, "left");
        this.add((Component)this._splitPane, "Center");
        this._splitPane.setDividerLocation(200);
        this._tree.setSelectionRow(0);
    }

    private synchronized void propertiesHaveChanged(String propName) {
        if (propName == null || propName.equals("metaDataOutputClassName") || propName.equals("tableContentsOutputClassName") || propName.equals("sqlResultsOutputClassName") || propName.equals("objectTabPlacement")) {
            SessionProperties props = this._session.getProperties();
            for (ObjectTreeTabbedPane pane : this._tabbedPanes.values()) {
                if (propName == null || propName.equals("metaDataOutputClassName") || propName.equals("tableContentsOutputClassName") || propName.equals("sqlResultsOutputClassName")) {
                    pane.rebuild();
                }
                if (propName != null && !propName.equals("objectTabPlacement")) continue;
                pane.getTabbedPane().setTabPlacement(props.getObjectTabPlacement());
            }
        }
    }

    private void onForceEditMode(boolean editable) {
        for (ObjectTreeTabbedPane pane : this._tabbedPanes.values()) {
            pane.rebuild();
        }
    }

    private void setupTabbedPane(ObjectTreeTabbedPane pane) {
        SessionProperties props = this._session.getProperties();
        pane.rebuild();
        JTabbedPane p = pane.getTabbedPane();
        p.setTabPlacement(props.getObjectTabPlacement());
        p.addChangeListener(this._tabPnlListener);
    }

    public void sessionWindowClosing() {
        this._findInObjectTreeController.dispose();
        this._tree.dispose();
    }

    @Override
    public FindInObjectTreeController getFindController() {
        return this._findInObjectTreeController;
    }

    @Override
    public Component getDetailTabComp() {
        return this._splitPane.getRightComponent();
    }

    @Override
    public void selectRoot() {
        this._session.getApplication().getThreadPool().addTask(new delaySelectionRunnable());
    }

    private class delaySelectionRunnable
    implements Runnable {
        private delaySelectionRunnable() {
        }

        @Override
        public void run() {
            Utilities.sleep(50L);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath rootPath = ObjectTreePanel.this._tree.getPathForRow(0);
                    ObjectTreePanel.this._tree.setSelectionPath(rootPath);
                }
            });
        }
    }

    private static class TabbedPaneListener
    implements ChangeListener {
        private TabbedPaneListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            Object src = evt.getSource();
            if (!(src instanceof JTabbedPane)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Source object in TabbedPaneListener was not a JTabbedpane").append(" - it was ").append(src == null ? "null" : src.getClass().getName());
                s_log.error(buf.toString());
                return;
            }
            JTabbedPane tabPane = (JTabbedPane)src;
            Object prop = tabPane.getClientProperty(ObjectTreeTabbedPane.IClientPropertiesKeys.TABBED_PANE_OBJ);
            if (!(prop instanceof ObjectTreeTabbedPane)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Client property in JTabbedPane was not an ObjectTreeTabbedPane").append(" - it was ").append(prop == null ? "null" : prop.getClass().getName());
                s_log.error(buf.toString());
                return;
            }
            ((ObjectTreeTabbedPane)prop).selectCurrentTab();
        }
    }

    private class SessionPropertiesListener
    implements PropertyChangeListener {
        private SessionPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ObjectTreePanel.this.propertiesHaveChanged(evt.getPropertyName());
        }
    }

    private final class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private ObjectTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            ObjectTreePanel.this.setSelectedObjectPanel(evt.getNewLeadSelectionPath());
        }
    }

    private final class LeftPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        LeftPanel() {
            super(new BorderLayout());
            this.add((Component)ObjectTreePanel.this._findInObjectTreeController.getFindInObjectTreePanel(), "North");
            JScrollPane sp = new JScrollPane();
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.setViewportView(ObjectTreePanel.this._tree);
            sp.setPreferredSize(new Dimension(200, 200));
            this.add((Component)sp, "Center");
        }
    }
}

