/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.AbstractPlasticController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

class MetalLookAndFeelController
extends AbstractPlasticController {
    private static ILogger s_log = LoggerController.createLogger(MetalLookAndFeelController.class);
    static final String METAL_LAF_CLASS_NAME = MetalLookAndFeel.class.getName();
    private String[] _extraThemeClassNames = new String[0];
    private MetalThemePreferences _currentThemePrefs;
    private MetalTheme _defaultMetalTheme;
    private static final String DEFAULT_METAL_THEME = "javax.swing.plaf.metal.OceanTheme";
    private HashMap<String, MetalTheme> _themesByName = new HashMap();

    MetalLookAndFeelController(LAFPlugin plugin, LAFRegister lafRegister) {
        super(plugin, lafRegister);
        try {
            this._extraThemeClassNames = new String[]{DEFAULT_METAL_THEME, "AquaTheme", "CharcoalTheme", "ContrastTheme", "EmeraldTheme", "RubyTheme", "net.sourceforge.squirrel_sql.client.gui.laf.AllBluesBoldMetalTheme"};
            this._defaultMetalTheme = new DefaultMetalTheme();
            XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
            Iterator it = cache.getAllForClass(MetalThemePreferences.class);
            if (it.hasNext()) {
                this._currentThemePrefs = (MetalThemePreferences)it.next();
            } else {
                this._currentThemePrefs = new MetalThemePreferences();
                ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
                Class<?> clazz = Class.forName(DEFAULT_METAL_THEME, false, cl);
                MetalTheme theme = (MetalTheme)clazz.newInstance();
                this._currentThemePrefs.setThemeName(theme.getName());
                try {
                    cache.add((IHasIdentifier)this._currentThemePrefs);
                }
                catch (DuplicateObjectException ex) {
                    s_log.error((Object)"MetalThemePreferences object already in XMLObjectCache", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    MetalTheme[] getExtraThemes() {
        ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
        Vector<MetalTheme> ret = new Vector<MetalTheme>();
        boolean defaultThemeIsIncluded = false;
        for (int i = 0; i < this._extraThemeClassNames.length; ++i) {
            try {
                Class<?> clazz = Class.forName(this._extraThemeClassNames[i], false, cl);
                MetalTheme metalTheme = (MetalTheme)clazz.newInstance();
                this._themesByName.put(metalTheme.getName(), metalTheme);
                ret.add(metalTheme);
                if (null == this._defaultMetalTheme || !this._extraThemeClassNames[i].equals(this._defaultMetalTheme.getClass().getName())) continue;
                defaultThemeIsIncluded = true;
                continue;
            }
            catch (Throwable th) {
                s_log.error((Object)("Error loading theme " + this._extraThemeClassNames[i]), th);
            }
        }
        if (!defaultThemeIsIncluded) {
            ret.add(this._defaultMetalTheme);
        }
        return ret.toArray(new MetalTheme[ret.size()]);
    }

    @Override
    MetalTheme getThemeForName(String name) {
        MetalTheme ret = super.getThemeForName(name);
        if (null == ret) {
            ret = this._themesByName.get(name);
        }
        return ret;
    }

    @Override
    void installCurrentTheme(LookAndFeel laf, MetalTheme theme) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        MetalLookAndFeel.setCurrentTheme(theme);
    }

    @Override
    String getCurrentThemeName() {
        return this._currentThemePrefs.getThemeName();
    }

    @Override
    void setCurrentThemeName(String name) {
        this._currentThemePrefs.setThemeName(name);
    }

    public static final class MetalThemePreferences
    extends AbstractPlasticController.ThemePreferences {
    }
}

