/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;
import org.fife.ui.app.AbstractPluggableGUIApplication;
import org.fife.ui.app.InvalidPluginException;
import org.fife.ui.app.Plugin;

class PluginLoader {
    public static final String PLUGIN_CLASS_ATTR = "Fife-Plugin-Class";
    public static final String PLUGIN_LOAD_PRIORITY = "Fife-Plugin-Load-Priority";
    public static final String[] LOAD_PRIORITIES = new String[]{"highest", "high", "normal", "low", "lowest"};
    private AbstractPluggableGUIApplication app;
    private File pluginDir;
    private URLClassLoader ucl;
    private boolean pluginSubmissionsCompleted;
    private int loadingPluginCount;
    private static final int SLEEP_TIME = 200;

    public PluginLoader(AbstractPluggableGUIApplication app) {
        this.app = app;
        this.pluginDir = new File(app.getInstallLocation(), "plugins");
    }

    private static final int getLoadPriority(Attributes attrs) {
        int priority = 2;
        String temp = attrs.getValue(PLUGIN_LOAD_PRIORITY);
        if (temp != null) {
            for (int i = 0; i < LOAD_PRIORITIES.length; ++i) {
                if (!LOAD_PRIORITIES[i].equalsIgnoreCase(temp)) continue;
                priority = i;
                break;
            }
        }
        return priority;
    }

    public synchronized boolean isPluginLoadingComplete() {
        return this.pluginSubmissionsCompleted && this.loadingPluginCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginImpl(String className) throws Exception {
        final Object[] objs = new Object[]{this.app};
        Class[] params = new Class[]{AbstractPluggableGUIApplication.class};
        Class<?> c = this.ucl.loadClass(className);
        if (Plugin.class.isAssignableFrom(c)) {
            PluginLoader pluginLoader = this;
            synchronized (pluginLoader) {
                ++this.loadingPluginCount;
            }
        } else {
            throw new InvalidPluginException("Specified plugin does not implement the Plugin interface: " + className);
        }
        final Constructor<?> cnst = c.getConstructor(params);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Plugin p = (Plugin)cnst.newInstance(objs);
                    PluginLoader.this.app.addPlugin(p);
                }
                catch (InvocationTargetException ite) {
                    Throwable e = ite.getTargetException();
                    e.printStackTrace();
                    PluginLoader.this.app.displayException(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PluginLoader.this.app.displayException(e);
                }
                finally {
                    1 ite = this;
                    synchronized (ite) {
                        PluginLoader.this.loadingPluginCount--;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlugins() throws IOException {
        if (!this.pluginDir.isDirectory()) {
            return;
        }
        File[] jars = this.pluginDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar");
            }
        });
        int jarCount = jars.length;
        ArrayList[] plugins = new ArrayList[LOAD_PRIORITIES.length];
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (int i = 0; i < jarCount; ++i) {
            urlList.add(jars[i].toURI().toURL());
            JarFile jarFile = new JarFile(jars[i]);
            try {
                Attributes attrs;
                String clazz;
                Manifest mf = jarFile.getManifest();
                if (mf == null || (clazz = (attrs = mf.getMainAttributes()).getValue(PLUGIN_CLASS_ATTR)) == null) continue;
                int priority = PluginLoader.getLoadPriority(attrs);
                if (plugins[priority] == null) {
                    plugins[priority] = new ArrayList(3);
                }
                plugins[priority].add(clazz);
                continue;
            }
            finally {
                jarFile.close();
            }
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        this.ucl = new URLClassLoader(urls, this.app.getClass().getClassLoader());
        this.loadPluginsImpl(plugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginsImpl(ArrayList[] plugins) {
        for (int p = 0; p < plugins.length; ++p) {
            int pluginCount = plugins[p] == null ? 0 : plugins[p].size();
            for (int i = 0; i < pluginCount; ++i) {
                try {
                    Thread.sleep(200L);
                    String className = (String)plugins[p].get(i);
                    this.loadPluginImpl(className);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PluginLoader.this.app.displayException(e);
                        }
                    });
                }
            }
        }
        PluginLoader pluginLoader = this;
        synchronized (pluginLoader) {
            this.pluginSubmissionsCompleted = true;
        }
    }
}

