/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationConstants;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.PluginOptionsDialogPanel;
import org.fife.ui.app.WizardDialogInfoPanel;
import org.fife.ui.app.WizardPluginDialog;

public abstract class WizardPlugin
implements Plugin,
GUIApplicationConstants {
    public static final int CANCEL = 0;
    public static final int SUCCESSFUL = 1;
    private GUIApplication app;
    private WizardPluginDialog dialog;
    private ArrayList infoPanels;

    public WizardPlugin(GUIApplication app) {
        this.app = app;
        this.infoPanels = new ArrayList(3);
    }

    protected int addInfoPanel(WizardDialogInfoPanel panel) {
        this.infoPanels.add(panel);
        return this.infoPanels.size();
    }

    protected abstract void createPanels();

    protected abstract WizardDialogInfoPanel getIntroductionPanel(WizardPluginDialog var1);

    protected WizardDialogInfoPanel getInfoPanel(int index, WizardPluginDialog dialog) {
        if (index <= 0 || index > this.getStepCount()) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        return (WizardDialogInfoPanel)this.infoPanels.get(index - 1);
    }

    public abstract PluginOptionsDialogPanel getOptionsDialogPanel();

    public Icon getSideIcon() {
        return new ImageIcon(){

            public int getIconHeight() {
                return 300;
            }

            public int getIconWidth() {
                return 120;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(Color.BLUE);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
        };
    }

    public final int getStepCount() {
        return this.infoPanels.size();
    }

    public abstract String getWizardDialogTitle();

    protected abstract WizardDialogInfoPanel getWizardSuccessfulPanel(WizardPluginDialog var1);

    protected abstract void handleWizardSuccessful(WizardDialogInfoPanel[] var1);

    public boolean promptBeforeCancel() {
        return true;
    }

    public final int runWizard() {
        this.infoPanels.clear();
        this.createPanels();
        this.dialog = this.app instanceof AbstractGUIApplication ? new WizardPluginDialog((Frame)((AbstractGUIApplication)this.app), this) : new WizardPluginDialog(this);
        String title = this.getWizardDialogTitle();
        this.dialog.setTitle(title);
        this.dialog.setLocationRelativeTo(null);
        int rc = this.dialog.runWizard();
        if (rc == 1) {
            WizardDialogInfoPanel[] wdip = new WizardDialogInfoPanel[this.infoPanels.size()];
            wdip = this.infoPanels.toArray(wdip);
            this.handleWizardSuccessful(wdip);
        }
        return rc;
    }
}

