/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ProgressMonitor;
import org.fife.ui.rtextfilechooser.FilePasteCallback;

public class DefaultFilePasteCallback
implements FilePasteCallback {
    private ProgressMonitor monitor;
    private String noteFormat;
    private static final String MSG = "org.fife.ui.rtextfilechooser.FilePaste";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FilePaste");

    public DefaultFilePasteCallback(Component parent) {
        this.monitor = new ProgressMonitor(parent, msg.getString("Dialog.ProgressMonitor.Title"), "", 0, 1);
    }

    public boolean filePasteUpdate(int pasteCount, int total, File justPastedFile) {
        this.monitor.setProgress(pasteCount - 1);
        this.monitor.setMaximum(total);
        if (justPastedFile != null) {
            if (this.noteFormat == null) {
                this.noteFormat = msg.getString("Dialog.ProgressMonitor.NoteFormat");
            }
            Object[] args = new Object[]{new Integer(pasteCount), new Integer(total), justPastedFile.getAbsolutePath()};
            String note = MessageFormat.format(this.noteFormat, args);
            this.monitor.setNote(note);
        }
        return this.monitor.isCanceled();
    }

    public void pasteOperationCompleted(int pasteCount) {
        this.monitor.close();
    }
}

