.TH tclreadline n "2.1.0" "Johannes Zellner"

.\" FILE: "/home/joze/src/tclreadline/tclreadline.n.in"
.\" LAST MODIFICATION: "Don, 20 Jul 2000 03:29:13 +0200 (joze)"
.\" (C) 1998 - 2000 by Johannes Zellner, <johannes@zellner.org>
.\" $Id: tclreadline.n.in,v 2.9 2000/08/27 13:25:24 msp Exp $
.\" ---
.\" tclreadline -- gnu readline for tcl
.\" http://www.zellner.org/tclreadline/
.\" Copyright (c) 1998 - 2000, Johannes Zellner <johannes@zellner.org>
.\" This software is copyright under the BSD license.


.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..

.SH "NAME"
tclreadline \- gnu readline for the tcl scripting language

.SH "SYNOPSIS"
.TP 6
\fB::tclreadline::readline\fP \fIcommand\fP [\fIoptions\fP]


.SH "DESCRIPTION"

The \fBtclreadline\fP package makes the gnu readline available
to the scripting language tcl. The primary purpose of the package
is to facilitate the interactive script development by the means
of word and file name completion as well as history expansion
(well known from shells like bash).

Additionally tclreadline can also be used for tcl scripts
which want to use a shell like input interface. In this case the
\fB::tclreadline::readline read\fP command has to be called explicitly.

.PP

The advantage of \fBtclreadline\fP is that it uses the callback
handler mechanism of the gnu readline while it processes tcl
events. This way X events from a wish gui will processed as
well as events from the \fPtclreadline\fP line interface.

.PP

\fBtclreadline\fP is basically a shared library and a few tcl scripts
which are accessed with the tcl package require command. Therefore
\fBtclreadline\fP should work with all common extensions like
\fBblt, itcl, itk, tix ...\fP.


.\" .SH SOURCE FILES


.SH "COMMANDS"

If you want to use \fBtclreadline\fP as a line interface
for developing tcl scripts, you probably don't have to read
this section. In this case the only thing you should do is
to modify your .tclshrc according to the section \fBFILES\fP.

For the functionality of the GNU readline you should refer to
the readline's documentation.

.PP
The following list will give all commands, which are currently
implemented in the shared lib (e.g. libtclreadline@TCLREADLINE_VERSION@.so).
Additional commands were introduced in a startup script
\fBtclreadlineSetup.tcl\fP, which lives in the tclreadline
installation directory.
(typically something like /usr/local/lib/tclreadline ..)
These commands are primarily for internal use and not documented here.

Note that all commands reside in the namespace \fB::tclreadline::\fP.


.TP 5
\fB::tclreadline::readline add\fP \fIstring\fP
adds a string to the completer. If the string contains white
spaces, each of the words will be completed consecutively when
hitting <Tab>. Example:

    ::tclreadline::readline add "button pathName ?options?"

typing but<Tab> will complete to button. Hitting <Tab> again
will complete to "button pathName".  ...

.TP 5
\fB::tclreadline::readline complete\fP \fIstring\fP
returns 1 if \fIstring\fP is a complete tcl command and 0 otherwise.

.TP 5
\fB::tclreadline::readline customcompleter\fP [\fIstring\fP]
Register the proc \fIstring\fP as custom completer. This proc is called
with exactly four arguments each time completion takes place:
the word to complete ("text"), the "start" and "end" positions of this word
in the line entered so far, and this line ("line"). The custom completion
script should return an array of strings which is a list of completions
for "text".  If there are no completions, it should return an empty
string "".  The first entry in the returned list is the substitution
for "text". The remaining entries are the possible completions. If
the custom completion script returns an empty string and builtin
completion is enabled (see \fBtclreadline::readline builtincompleter\fP),
the builtin completer is called.
\fBtclreadline::readline customcompleter\fP simply returns the current
custom completer if called w/o \fIstring\fP. To turn of custom
completion, call \fBtclreadline::readline customcompleter\fP with
an empty \fIstring\fP.

Example: \fB% puts $b<TAB>\fP will call the custom completer
with the four arguments \fI"$b"\fP, \fI"5"\fP, \fI"8"\fP and \fI"puts $b"\fP.
The custom completer could return a string like "$bl $black $blue", which
will complete "$b" to "$bl" (the longest match) and offer a list of two
further matches "$black" and "$blue".

For further reference, see the proc tclreadline::ScriptCompleter in
the file tclreadlineSetup.tcl.

.TP 5
\fB::tclreadline::readline builtincompleter\fP [\fIbool\fP]
enable or disable the builtin completer. If the builtin completer
is enabled, it will be invoked either if there is no custom completer,
or the custom completer returned an empty  string. The builtin
completer is on by default.
\fBtclreadline::readline builtincompleter\fP returns the current
custom completer (also, if called w/o the \fIbool\fP argument).

.TP 5
\fB::tclreadline::readline eofchar\fP [\fIscript\fP]
set a script which will be called, if readline returns the eof character
(this is typically the case if CTRL-D is entered at the very beginning
of the line). The default for this script is "puts {}; exit". Setting
this to an empty value disables any action on eof.
\fBtclreadline::readline eof\fP returns the current eof script.

.TP 5
\fB::tclreadline::readline initialize\fP \fIhistoryfile\fP
initialize the tclreadline interface and read the history from
the \fIhistoryfile\fP. On succes an empty string is returned.
This command has to be called before any other tclreadline commands.

.TP 5
\fB::tclreadline::readline read\fP \fIprompt\fP
prints the \fIprompt\fP to stdout and enters the tclreadline event
loop. Both readline and X events are processed. Returns the
(eventually history-expanded) input string.
\fBtclreadline::readline read\fP rises an error, if an
error occurs while evaluating a script completer.

.TP 5
\fB::tclreadline::readline write\fP \fIhistoryfile\fP
writes the history to the \fIhistoryfile\fP. This command is called
automatically from the internal routine ::tclreadline::Exit.
If the variable \fBtclreadline::historyLength\fP is non-negative,
the historyfile will be truncated to hold only this number lines.

.TP 5
\fB::tclreadline::readline reset-terminal\fP [\fIterminalName\fP]
w/o argument: reset the state of the terminal to what it was
before tclreadline was used. With argument: reinitialize readline's
idea of the terminal settings using terminalName as the terminal type.
The form w/o argument might not work if tclreadline was compiled
with an older version of libreadline.

.TP 5
\fB::tclreadline::readline bell\fP
Ring the terminal bell, obeying the setting of bell-style
-- audible or visible.

.TP 5
\fB::tclreadline::text\fP
Return the current input.

.TP 5
\fB::tclreadline::readline update\fP
Redraw the current input line.

.TP 5
\fB::tclreadline::Print\fP [\fIyes / no\fP]
turns on or off the default behavior of tclsh to print the result of
every command. This is turned on by default, so it will just behave
as the tclsh w/o tclreadline. Turning off might be useful, when reading
binary data for example. If \fB::tclreadline::Print\fP is called w/o
arguments, it returns the current setting.

.TP 5
\fB::tclreadline::Loop\fP [\fIhistoryfile\fP]
enter the tclreadline main loop. This command is typically called from
the startup resource file (something .tclshrc, depending on the interpreter
you use, see the file `sample.tclshrc'). The main loop sets up some
completion characteristics as variable -- try something like "puts $b<TAB>" -- 
and command completion -- try "puts [in<TAB>".
If the optional argument \fIhistoryfile\fP is given, this file will
be used for reading and writing the command history instead of the
default \fB.tclsh-history\fP.
\fB::tclreadline::Loop\fP will normally not return. 
If you want to write your own main loop and/or own custom completers,
it is probably a good idea to start with tclreadline::Loop
(see the file tclreadlineSetup.tcl).

.TP 5
\fB::tclreadline::prompt1\fP
a proc which is called by ::tclreadline::Loop and returns a string
which will be displayed as the primary prompt. This prompt will be
something like "[info nameofexecutable] \[[pwd]\]" possibly fancy colored.
The default proc is defined on entering the ::tclreadline::Loop,
if it is not already defined. So: If you define your own proc
::tclreadline::prompt1 before entering ::tclreadline::Loop, this
proc is called each time the prompt is to be displayed.
Example:
.CS
    package require tclreadline
    namespace eval tclreadline {
        proc prompt1 {} {
            return "[clock format [clock seconds]]> "
        }
    }
    ::tclreadline::Loop
.CE

Note that non-printable control characters as color control characters
must be enclosed in literal ctrl-a / ctrl-b to tell readline the length
of the printable prompt. See for example the variable `prompt_string'
in the file tclreadlineSetup.tcl in your tclreadline installation directory.


.\" .SH "EXAMPLES"


.\" .SH "ENVIRONMENT VARIABLES"

.SH "VARIABLES"

\fItclreadline\fP defines the following variables in the
namespace \fI::tclreadline\fP:
(for backwards compatiblity the global variables tclreadline_version,
 tclreadline_patchLevel and tclreadline_library are still present).

.TP 5
\fBtclreadline::version\fP (read-only)
holds the version string "@TCLREADLINE_VERSION@".

.TP 5
\fBtclreadline::patchLevel\fP (read-only)
holds the patch level string "2.1.0".

.TP 5
\fBtclreadline::library\fP (read-only)
holds the library string "@TCLREADLINE_LIBRARY@".

.TP 5
\fBtclreadline::license\fP (read-only)
holds a BSD license statement.

.TP 5
\fBtclreadline::historyLength\fP
Number of lines, which will be written to the historyfile.
This number is -1 by default, which means that the historyfile
will not be truncated.  See also \fBtclreadline::write\fP.

.SH "FILES"

the \fB.tclshrc\fP file in the HOME directory, which
is read on tclsh startup. Alternatively, the name of this initialization
file might be \fB.wishrc\fP ... depending on what interpreter you use.
These files should typically contain something like
.CS
    if {$tcl_interactive} {
        package require tclreadline
        ::tclreadline::Loop
    }
.CE

which will enter the tclreadline main loop.

.PP
the \fB.tclsh-history\fP file in the HOME directory. On startup
commands will be read from this file. On exit, the readline history
is written to this file. Note that if you abort tclsh with <cntrl-c>
no history is written. For the future it is planned to set up a signal
handler, which will write the history on <ctrl-c> before exiting.

.PP
the \fB.inputrc\fP file in the users HOME directory. This file
is used normally for all programs which use the gnu readline (e.g.  bash).
The `global' readline settings there will be valid also for
\fBtclreadline\fP. Additionally the .inputrc might hold conditional
settings for the implementation name \fBtclreadline\fP. Example of 
some lines in your .inputrc:
.CS
    $if tclreadline
    "\\C-xp": "puts $env(PATH)"
    $endif
.CE

For further documentation please refer to the gnu readline documentation.

.SH "BUGS"
citing the readline manual:  It's too big and too slow.


.SH "SEE ALSO"


.PP
The official \fBtclreadline\fP web site at:

.PP
.RS 4
http://www.zellner.org/tclreadline/
.RE


.SH "AUTHOR"
Johannes Zellner, <johannes@zellner.org>

.SH "CONTRIBUTIONS, SUGGESTIONS AND PATCHES"
Magnus Eriksson <magnus.eriksson@netinsight.se>,
Les Johnson <les@infolabs.com>,
Harald Kirsch <kir@iitb.fhg.de>,
Christian Krone <krischan@sql.de>,
Larry W. Virden <lvirden@cas.org>,
David Engel <dlengel@home.com> <david@debian.org>,
Matthew Clarke <Matthew_Clarke@mindlink.bc.ca>

.SH "DEBIAN PACKAGE"
David Engel <dlengel@home.com>, <david@debian.org>

.SH "DISCLAIMER"

\fBtclreadline\fP comes with a BSD type license.
The read-only variable tclreadline::license holds the
complete license statement.
