# This is a *SAMPLE* of conf.ph.
# this configuration assumes very standard environment
# using static mode without any logging, cacheing system.

# diary files(tdf file) should be located at '../diary_dir/CCYY/MM/DD.tdf'.
# we put a sample tdf at '../diary_dir/2000/01/01.tdf', so
# you can create some directories and files refering that sample.

# but, we insist that you had better doning 'perl install.pl'.
# and so, legal 'conf.ph' is created automatically.

# we repeat, this is a ONLY SAMPLE of conf.ph.

# $Id: conf.ph,v 1.79.2.3 2001/02/20 14:16:13 tom Exp $
################################################################

##BEGIN{ warn " conf.ph start"; }

use TDS::System;
use TDS::IdentInfo;
use TDS::DirInfo;

##warn " conf.ph use done";

# server setting
$TDS::System::PerlPath = q(/usr/local/bin/perl);
$TDS::System::SendmailPath = q(/usr/lib/sendmail);
$TDS::System::CanUseCGI = 0;      # you must do 'chmod 755 *.cgi' if set as '1'
$TDS::System::CanUseSSI = 0;
$TDS::System::TZ = q(JST);

# directory
# you MUST change this directory variable:
#   set absolute path of 'web_diary_dir' under tds installed directory.
#   such as '/home/users/foo/public_html/tds/web_diary_dir'.
$TDS::DirInfo::WebDiaryDir = q(/home/users/foo/public_html/tds/web_diary_dir);
$TDS::DirInfo::CustomizeDir = q(/home/users/foo/public_html/tds/diary_dir/custom);
$TDS::DirInfo::DiaryDir = q(/home/users/foo/public_html/tds/diary_dir/diary);

# mode
$TDS::Mode::Mode = 'dynamic';
#$TDS::Mode::Mode = 'static';
$TDS::AccessLog::EnableAccessLog = 0;    # you must create 'log' directory if use
$TDS::Cookie::EnableCookie = 0;
$TDS::Cache::EnableCache = 0;     # you must create 'cache' directory if use
                                  # if in static mode, should be 'cache_static'

# additional
$TDS::SetupedVersion = qq(1.4.1); # set legal version by refering lib/TDS.pm by hand

# for debugging
if ($TDS::Unreleased){
    $TDS::IdentInfo::DiaryURL = q(http://127.0.0.1/~tom/tds-1.4-stable/web_diary_dir/);
    $TDS::System::CanUseCGI = 1;
    $TDS::System::CanUseSSI = 1;
    $TDS::AccessLog::EnableAccessLog = 1;
    $TDS::Cookie::EnableCookie = 1;
    $TDS::Cache::EnableCache = 1;

    if ($^O =~ /Win32/i){
	$TDS::DirInfo::WebDiaryDir = q(d:/tom/www/tds-1.4-stable/web_diary_dir);
	$TDS::DirInfo::CustomizeDir = q(d:/tom/www/tds-1.4-stable/diary_dir/custom);   
	$TDS::DirInfo::DiaryDir = q(d:/tom/diary);
#	$TDS::DirInfo::DiaryDir = "../diary_dir";
    } else {
	$TDS::DirInfo::WebDiaryDir = q(/home/general/tom/www/tds-1.3-current/web_diary_dir);
	$TDS::DirInfo::CustomizeDir = q(/home/general/tom/www/tds-1.3-current/diary_dir/custom);
#	$TDS::DirInfo::CustomizeDir = q(/home/general/tom/diary/customize);
	$TDS::DirInfo::DiaryDir = q(/home/general/tom/diary);
    }
}

1;

