package DateTime::Format;
# DateTime::Format
#
# Copyright (c) 1995-8 Graham Barr. All rights reserved. This program is free
# software; you can redistribute it and/or modify it under the same terms
# as Perl itself.

use     strict;
use     vars qw(@EXPORT @ISA $VERSION);
require Exporter;

use Time::Local;
use DateTime::Zone;
use DateTime::Date;
#use DateTime::Format::Generic;
require DateTime::Format::Generic;

$VERSION = "2.09"; # $Id: Format.pm,v 1.9 2000/12/25 05:46:50 tom Exp $
@ISA     = qw(Exporter);
@EXPORT  = qw(time2str time2str_gen strftime ctime asctime str2time);

sub time2str ($;$$)
{
 DateTime::Format::Generic->time2str(@_);
}

sub time2str_gen ($;$$)
{
 DateTime::Format::Generic->time2str("%a %b %e %T %Y %Z", @_);
}


sub strftime ($\@;$)
{
 DateTime::Format::Generic->strftime(@_);
}

sub ctime ($;$)
{
 my($t,$tz) = @_;
 DateTime::Format::Generic->time2str("%a %b %e %T %Y\n", $t, $tz); 
}

sub asctime (\@;$)
{
 my($t,$tz) = @_;
 DateTime::Format::Generic->strftime("%a %b %e %T %Y\n", $t, $tz); 
}

##
##
##

##
##
##
################################################################
sub str2time($;$)
{
    my ($str, $tz) = @_;
    my ($day, $month, $year, $hour, $min, $sec);

#    print ref $_;
    my $tmp = $_;
    $_ = $str;
   
    # ʬ
    if(m%(\d+):(\d+):(\d+)%){
	($hour, $min, $sec) = ($1, $2, $3);
    } elsif(m%(\d+):(\d+)%){
	($hour, $min, $sec) = ($1, $2, 0);
    } elsif (m%(\d+)(\d+)ʬ(\d+)%){
	($hour, $min, $sec) = ($1, $2, $3);
    } elsif (m%(\d+)(\d+)ʬ%){
	($hour, $min, $sec) = ($1, $2, 0);
    }

    # ǯ
    my $now_year = (gmtime(time()))[5];
    
    if(m%(\d+)/(\d+)/(\d+)%){
	($year, $month, $day) = ($1, $2, $3);
    } elsif(m%(\d+)/(\d+)%){
	($year, $month, $day) = ($now_year, $1, $2);
    } elsif(m%(\d+)\.(\d+)\.(\d+)%){
	($year, $month, $day) = ($1, $2, $3);
    } elsif(m%(\d+)\-(\d+)\-(\d+)%){
	($year, $month, $day) = ($1, $2, $3);
    } elsif(m%(\d+)ǯ *(\d+) *(\d+)%){
	($year, $month, $day) = ($1, $2, $3);
    } elsif(m%(\d+) *(\d+)%){
	($year, $month, $day) = ($now_year, $1, $2);
    }

    if (m%\w+,\s+(\d+)\s(\w{3})\s(\d\d+)\s(\d+):(\d+):(\d+)\s(\w{3,4})%io){
	# rfc1123 "Sun, 06 Nov 1994 08:49:37 GMT"
	($day, $month, $year, $hour, $min, $sec, $tz) =
	    ($1, DateTime::Date::GetMonthNumber('ABBR', $2), $3, $4, $5, $6, $7);
#	print "a, $2, $month, ";
    } elsif (m%\w+,\s+(\d+)\s(\w{3})\s(\d\d+)%io){
	# rfc1123? "Fri, 25 Feb 2000"
	($day, $month, $year) =
	    ($1, DateTime::Date::GetMonthNumber('ABBR', $2), $3);
#	print "b, ";
    }elsif(m%\w+\s(\w+)\s+(\d+)\s(\d+):(\d+):(\d+)\s(\d+)\s?(\w{3,4})?%io){
	# Sun Nov 6 08:49:37 1994(ANSI C's asctime() format)
	($month, $day, $hour, $min, $sec, $year, $tz) =
	    (DateTime::Date::GetMonthNumber('ABBR', $1), $2, $3, $4, $5, $6, $7);
#	print "c, ";
    }elsif(m%\w+,\s(\d+)\-(\w+)\-(\d+)\s(\d+):(\d+):(\d+)\s(\w{3,4})%io){
	# rfc1036 "Sunday, 06-Nov-94 08:49:37 GMT"
	($day, $month, $year, $hour, $min, $sec, $tz) =
	    ($1, DateTime::Date::GetMonthNumber('ABBR', $2), $3, $4, $5, $6, $7);
#	print "d, ";
    }elsif(m%\w+,\s(\d+)\-(\w+)\-(\d+)\s(\d+):(\d+):(\d+)%io){
	# rfc1036 "Wednesday, 05-Jan-00 15:49:28"
	($day, $month, $year, $hour, $min, $sec) =
	    ($1, DateTime::Date::GetMonthNumber('ABBR', $2), $3, $4, $5, $6);
#	print "e, ";
    }elsif(m%(\d+)/(\d+)/(\d+)\s(\d+):(\d+):(\d+)\s(\w{3,4})%io){
	# 1999/11/10 17:03:06 JST
	($year, $month, $day, $hour, $min, $sec, $tz) =
	    ($1, DateTime::Date::GetMonthNumber('ABBR', $2), $3, $4, $5, $6, $7);
#	print "f, ";
#    } else {
#	return 0;
    }
#    print "$year/$month/$day $hour:$min:$sec $tz, ";
    $_ = $tmp;
    if ($day){    # Ƥ OK ȸ
	$year -= 1900 if($year >= 1900);
	$year += 100 if($year < 70);
	$month--;
	$tz ||= 'GMT';
	
	if ($month < 0 || $month > 11){
	    $month = 0;
	}
	return timegm($sec, $min, $hour, $day, $month, $year) - tz_offset($tz);
    } else {
	return undef;
    }
}
    
1;
