/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.util.VoidValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GrammarPart
implements ComponentVisitor<VoidValue> {
    private final ErrorReporter er;
    private final Map<String, Pattern> defines;
    private final Set<String> attlists;
    private final Set<String> implicitlyCombinedDefines;
    private final Map<String, Combine> combineTypes;
    private final SchemaCollection schemas;
    private final Map<String, GrammarPart> parts;
    private final Map<String, Component> whereProvided = new HashMap<String, Component>();
    private final Set<String> pendingIncludes;

    GrammarPart(ErrorReporter errorReporter, Map<String, Pattern> map, Set<String> set, SchemaCollection schemaCollection, Map<String, GrammarPart> map2, GrammarPattern grammarPattern) {
        this.er = errorReporter;
        this.defines = map;
        this.attlists = set;
        this.schemas = schemaCollection;
        this.parts = map2;
        this.pendingIncludes = new HashSet<String>();
        this.implicitlyCombinedDefines = new HashSet<String>();
        this.combineTypes = new HashMap<String, Combine>();
        this.visitContainer(grammarPattern);
    }

    private GrammarPart(GrammarPart grammarPart, GrammarPattern grammarPattern) {
        this.er = grammarPart.er;
        this.defines = grammarPart.defines;
        this.schemas = grammarPart.schemas;
        this.parts = grammarPart.parts;
        this.attlists = grammarPart.attlists;
        this.pendingIncludes = grammarPart.pendingIncludes;
        this.implicitlyCombinedDefines = grammarPart.implicitlyCombinedDefines;
        this.combineTypes = grammarPart.combineTypes;
        this.visitContainer(grammarPattern);
    }

    Set<String> providedSet() {
        return this.whereProvided.keySet();
    }

    public VoidValue visitContainer(Container container) {
        List<Component> list = container.getComponents();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitDiv(DivComponent divComponent) {
        return this.visitContainer(divComponent);
    }

    @Override
    public VoidValue visitDefine(DefineComponent defineComponent) {
        Object object;
        String string = defineComponent.getName();
        Combine combine = defineComponent.getCombine();
        if (combine == null) {
            if (this.implicitlyCombinedDefines.contains(string)) {
                this.er.error("multiple_no_combine", string, defineComponent.getSourceLocation());
            } else {
                this.implicitlyCombinedDefines.add(string);
            }
        } else {
            object = this.combineTypes.get(string);
            if (object != null) {
                if (object != combine) {
                    this.er.error("inconsistent_combine", defineComponent.getSourceLocation());
                }
            } else {
                this.combineTypes.put(string, combine);
            }
        }
        object = this.defines.get(string);
        if (object != null) {
            if (combine == Combine.CHOICE) {
                this.er.error("sorry_combine_choice", defineComponent.getSourceLocation());
            } else if (combine == Combine.INTERLEAVE) {
                InterleavePattern interleavePattern = new InterleavePattern();
                interleavePattern.getChildren().add((Pattern)object);
                interleavePattern.getChildren().add(defineComponent.getBody());
                interleavePattern.setSourceLocation(defineComponent.getSourceLocation());
                this.defines.put(string, interleavePattern);
                this.attlists.add(string);
            }
        } else {
            this.defines.put(string, defineComponent.getBody());
            this.whereProvided.put(string, defineComponent);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitInclude(IncludeComponent includeComponent) {
        String string = includeComponent.getUri();
        if (this.pendingIncludes.contains(string)) {
            throw new IncludeLoopException(includeComponent);
        }
        this.pendingIncludes.add(string);
        GrammarPattern grammarPattern = (GrammarPattern)this.schemas.getSchemaDocumentMap().get(string).getPattern();
        GrammarPart grammarPart = new GrammarPart(this, grammarPattern);
        this.parts.put(string, grammarPart);
        for (String string2 : grammarPart.providedSet()) {
            this.whereProvided.put(string2, includeComponent);
        }
        this.pendingIncludes.remove(string);
        return VoidValue.VOID;
    }

    Component getWhereProvided(String string) {
        return this.whereProvided.get(string);
    }

    public static class IncludeLoopException
    extends RuntimeException {
        private final IncludeComponent include;

        public IncludeLoopException(IncludeComponent includeComponent) {
            this.include = includeComponent;
        }

        public IncludeComponent getInclude() {
            return this.include;
        }
    }
}

